/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.client.audio;

import java.util.HashMap;
import java.util.Map;
import org.collebol.client.audio.AudioPlayer;
import org.collebol.client.audio.Sound;
import org.collebol.client.math.VolumeCalculator;
import org.collebol.shared.math.Vector2D;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALCapabilities;

public class SoundPlayer
implements AudioPlayer {
    private String name;
    private long device;
    private long context;
    private Map<Integer, Sound> sounds = new HashMap<Integer, Sound>();

    public SoundPlayer(String name) {
        this.name = name;
        String defaultDeviceName = ALC10.alcGetString((long)0L, (int)4100);
        this.device = ALC11.alcOpenDevice((CharSequence)defaultDeviceName);
        if (this.device == 0L) {
            throw new IllegalStateException("Failed to open an OpenAL device.");
        }
        int[] attributes = new int[]{0};
        this.context = ALC10.alcCreateContext((long)this.device, (int[])attributes);
        ALC10.alcMakeContextCurrent((long)this.context);
        ALCCapabilities alcCapabilities = ALC.createCapabilities((long)this.device);
        ALCapabilities alCapabilities = AL.createCapabilities((ALCCapabilities)alcCapabilities);
    }

    public void registerSound(Sound sound) {
        this.sounds.put(sound.getId(), sound);
    }

    public void playSound(int id, Vector2D listenerPosition) {
        if (!this.sounds.containsKey(id)) {
            throw new RuntimeException("Invalid Sound id: " + id + ". Register Sound before using!");
        }
        Sound sound = this.sounds.get(id);
        if (sound.getPath() == null) {
            throw new RuntimeException("Sound path equals null. Please, set a sound path before using!");
        }
        int pointer = sound.getSource();
        AL10.alSourcef((int)pointer, (int)4106, (float)VolumeCalculator.calculate(sound, listenerPosition));
        AL10.alSourcef((int)pointer, (int)4099, (float)sound.getPitch());
        AL10.alSourcePlay((int)pointer);
    }

    public void playSound(int id) {
        if (!this.sounds.containsKey(id)) {
            throw new RuntimeException("Invalid Sound id: " + id + ". Register Sound before using!");
        }
        Sound sound = this.sounds.get(id);
        if (sound.getPath() == null) {
            throw new RuntimeException("Sound path equals null. Please, set a sound path before using!");
        }
        int pointer = sound.getSource();
        AL10.alSourcef((int)pointer, (int)4106, (float)VolumeCalculator.calculate(sound, new Vector2D(0.0f, 0.0f)));
        AL10.alSourcef((int)pointer, (int)4099, (float)sound.getPitch());
        AL10.alSourcePlay((int)pointer);
    }

    public void playModifiedSound(ModifySound sound, Vector2D listenerPosition) {
        if (!this.sounds.containsKey(sound.getId())) {
            throw new RuntimeException("Invalid Sound id: " + sound.getId() + ". Register Sound before using!");
        }
        if (this.sounds.get(sound.getId()).getPath() == null) {
            throw new RuntimeException("Sound path equals null. Please, set a sound path before using!");
        }
        int pointer = this.sounds.get(sound.getId()).getSource();
        AL10.alSourcef((int)pointer, (int)4106, (float)VolumeCalculator.calculate(sound, listenerPosition));
        AL10.alSourcef((int)pointer, (int)4099, (float)sound.getPitch());
        AL10.alSourcePlay((int)pointer);
    }

    public void playModifiedSound(ModifySound sound) {
        if (!this.sounds.containsKey(sound.getId())) {
            throw new RuntimeException("Invalid Sound id: " + sound.getId() + ". Register Sound before using!");
        }
        if (this.sounds.get(sound.getId()).getPath() == null) {
            throw new RuntimeException("Sound path equals null. Please, set a sound path before using!");
        }
        int pointer = this.sounds.get(sound.getId()).getSource();
        AL10.alSourcef((int)pointer, (int)4106, (float)VolumeCalculator.calculate(sound, new Vector2D(0.0f, 0.0f)));
        AL10.alSourcef((int)pointer, (int)4099, (float)sound.getPitch());
        AL10.alSourcePlay((int)pointer);
    }

    public void disable() {
        for (Sound s : this.sounds.values()) {
            AL10.alDeleteSources((int)s.getSource());
        }
        ALC10.alcDestroyContext((long)this.context);
        ALC10.alcCloseDevice((long)this.device);
    }

    public String getName() {
        return this.name;
    }

    public static class ModifySound
    extends Sound {
        public ModifySound(int id, SoundPlayer soundPlayer) {
            super(new Sound.SoundBuilder(id, soundPlayer.sounds.get(id).getPath()).position(soundPlayer.sounds.get(id).getPosition()).volume(soundPlayer.sounds.get(id).getVolume()).pitch(soundPlayer.sounds.get(id).getPitch()).refDistance(soundPlayer.sounds.get(id).getRefDistance()).rollOffFactor(soundPlayer.sounds.get(id).getRollOffFactor()));
        }

        public ModifySound position(Vector2D position) {
            this.setPosition(position);
            return this;
        }

        public ModifySound volume(float volume) {
            this.setVolume(volume);
            return this;
        }

        public ModifySound pitch(float pitch) {
            this.setPitch(pitch);
            return this;
        }

        public ModifySound refDistance(float distance) {
            this.setRefDistance(distance);
            return this;
        }

        public ModifySound rollOffFactor(float factor) {
            this.setRollOffFactor(factor);
            return this;
        }
    }
}

