/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.client;

import org.collebol.client.ExamplePanel;
import org.collebol.client.audio.SoundHandler;
import org.collebol.client.event.ClientEventHandler;
import org.collebol.client.gui.MainWindow;
import org.collebol.client.gui.graphics.renderer.RenderHandler;
import org.collebol.client.gui.graphics.renderer.ui.UIRenderer;
import org.collebol.client.gui.graphics.ui.ComponentHandler;
import org.collebol.client.utils.EngineInfo;
import org.collebol.client.utils.GameInfo;

public abstract class EJGEngine {
    private MainWindow window;
    private EngineInfo engineInfo = new EngineInfo();
    private GameInfo gameInfo;
    private RenderHandler renderRegisterHandler;
    private ClientEventHandler eventHandler = new ClientEventHandler(this);
    private SoundHandler soundHandler;
    private ComponentHandler componentHandler;

    public void start() {
        this.setup();
        this.window = new MainWindow(this);
        this.renderRegisterHandler = new RenderHandler();
        this.soundHandler = new SoundHandler(this);
        this.componentHandler = new ComponentHandler();
        this.getRenderers().registerNewRenderer(new UIRenderer(this));
        this.window.registerPanel(new ExamplePanel(this));
        this.window.setPanel(0);
        this.enable();
        this.window.run();
        this.disable();
    }

    public abstract void setup();

    public abstract void register();

    public abstract void enable();

    public abstract void disable();

    public MainWindow getWindow() {
        return this.window;
    }

    public ClientEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(ClientEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public RenderHandler getRenderers() {
        return this.renderRegisterHandler;
    }

    public SoundHandler getSoundHandler() {
        return this.soundHandler;
    }

    public ComponentHandler getComponentHandler() {
        return this.componentHandler;
    }

    public EngineInfo getEngineInfo() {
        return this.engineInfo;
    }

    public GameInfo getGameInfo() {
        if (this.gameInfo == null) {
            throw new RuntimeException("You are trying to get your game info, but you have not set one yet!");
        }
        return this.gameInfo;
    }

    public <T extends GameInfo> void setGameInfo(T gameInfo) {
        if (gameInfo == null) {
            return;
        }
        this.gameInfo = gameInfo;
    }
}

