/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.client.audio;

import java.util.HashMap;
import java.util.Map;
import org.collebol.client.EJGEngine;
import org.collebol.client.audio.AudioPlayer;
import org.collebol.client.audio.CameraSoundPlayer;
import org.collebol.client.audio.SoundPlayer;

public class SoundHandler {
    private EJGEngine engine;
    private Map<String, SoundPlayer> soundPlayers;
    private Map<String, CameraSoundPlayer> cameraPlayers;

    public SoundHandler(EJGEngine e) {
        this.engine = e;
        this.soundPlayers = new HashMap<String, SoundPlayer>();
        this.cameraPlayers = new HashMap<String, CameraSoundPlayer>();
        this.soundPlayers.put("default", new SoundPlayer("default"));
        this.cameraPlayers.put("default", new CameraSoundPlayer("default", this.engine));
    }

    public <T extends AudioPlayer> void registerNewPlayer(T audioPlayer) {
        if (audioPlayer instanceof SoundPlayer) {
            if (this.soundPlayers.containsKey(((SoundPlayer)audioPlayer).getName())) {
                throw new RuntimeException("SoundPlayer with the name: " + ((SoundPlayer)audioPlayer).getName() + " already exists. Please, make sure to give it a original name!");
            }
            this.soundPlayers.put(((SoundPlayer)audioPlayer).getName(), (SoundPlayer)audioPlayer);
        }
        if (audioPlayer instanceof CameraSoundPlayer) {
            if (this.cameraPlayers.containsKey(((CameraSoundPlayer)audioPlayer).getName())) {
                throw new RuntimeException("CameraSoundPlayer with the name: " + ((CameraSoundPlayer)audioPlayer).getName() + " already exists. Please, make sure to give it a original name!");
            }
            this.cameraPlayers.put(((CameraSoundPlayer)audioPlayer).getName(), (CameraSoundPlayer)audioPlayer);
        }
    }

    public SoundPlayer getSoundPlayer(String name) {
        if (this.soundPlayers.isEmpty()) {
            throw new RuntimeException("You are trying to play sound with no SoundPlayer('s) registered! Please, register a SoundPlayer before using!");
        }
        if (name == "default" && !this.soundPlayers.containsKey(name)) {
            throw new RuntimeException("Please, register a Default SoundPlayer in the register() method with the name 'default'.");
        }
        if (this.soundPlayers.get(name) != null) {
            return this.soundPlayers.get(name);
        }
        throw new RuntimeException("SoundPlayer not found: " + name);
    }

    public CameraSoundPlayer getCameraPlayer(String name) {
        if (this.cameraPlayers.isEmpty()) {
            throw new RuntimeException("You are trying to play sound with no CameraSoundPlayer('s) registered! Please, register a CameraSoundPlayer before using!");
        }
        if (name == "default" && !this.cameraPlayers.containsKey("default")) {
            throw new RuntimeException("Please, register a Default CameraSoundPlayer in the register() method with the name 'default'.");
        }
        if (this.cameraPlayers.get(name) != null) {
            return this.cameraPlayers.get(name);
        }
        throw new RuntimeException("CameraSoundPlayer not found: " + name);
    }
}

