/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.client.gui;

import org.collebol.client.EJGEngine;
import org.collebol.client.gui.graphics.Camera;
import org.collebol.client.gui.graphics.Text;
import org.collebol.shared.math.Vector2D;

public abstract class Panel {
    public int id;
    private Camera camera;
    private float DT;
    private int currentFPS;
    private EJGEngine engine;

    public Panel(int id, EJGEngine e) {
        this.id = id;
        this.engine = e;
        this.camera = new Camera(new Vector2D(0.0f, 0.0f), 1.0f, 0.0f, this.engine);
        this.currentFPS = (int)Math.floor(1.0f / this.getDT());
    }

    public void showScreenDetails(float size) {
        this.getEngine().getRenderers().getTextRenderer("default").render(new Text(new Text.TextBuilder().text("EJGEngine version: " + this.getEngine().getEngineInfo().getVersion()).position(new Vector2D(10.0f, -35.0f + size * 2.0f)).size(size).scale(1.0f).align(Text.ALIGN_TOP_LEFT).rotation(0.0f)));
        this.getEngine().getRenderers().getTextRenderer("default").render(new Text(new Text.TextBuilder().text("Window width: " + this.getEngine().getWindow().getWidth() + "px").position(new Vector2D((float)this.getEngine().getWindow().getWidth() - 10.0f, -10.0f + size * 2.0f)).size(size).scale(1.0f).align(Text.ALIGN_TOP_RIGHT).rotation(0.0f)));
        this.getEngine().getRenderers().getTextRenderer("default").render(new Text(new Text.TextBuilder().text("Window height: " + this.getEngine().getWindow().getHeight() + "px").position(new Vector2D((float)this.getEngine().getWindow().getWidth() - 10.0f, 10.0f + size * 2.0f)).size(size).scale(1.0f).align(Text.ALIGN_TOP_RIGHT).rotation(0.0f)));
        this.getEngine().getRenderers().getTextRenderer("default").render(new Text(new Text.TextBuilder().text("FPS: " + this.getCurrentFPS()).position(new Vector2D((float)this.getEngine().getWindow().getWidth() - 10.0f, 35.0f + size * 2.0f)).size(size).scale(1.0f).align(Text.ALIGN_TOP_RIGHT).rotation(0.0f)));
    }

    public abstract void update();

    public abstract void paint();

    public EJGEngine getEngine() {
        return this.engine;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public float getDT() {
        return this.DT;
    }

    public void setDT(float DT) {
        this.DT = DT;
    }

    public int getCurrentFPS() {
        return this.currentFPS;
    }

    public void setCurrentFPS(int currentFPS) {
        this.currentFPS = currentFPS;
    }
}

