/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.client.gui.graphics.renderer;

import java.util.ArrayList;
import java.util.Iterator;
import org.collebol.client.EJGEngine;
import org.collebol.client.gui.graphics.renderer.Renderer;
import org.collebol.game.GameManager;
import org.collebol.game.world.Chunk;
import org.collebol.game.world.World;
import org.collebol.shared.objects.entity.Entity;
import org.collebol.shared.objects.entity.Player;

public class WorldRenderer
extends Renderer {
    private World world;
    private GameManager gameManager;
    private EJGEngine engine;

    public WorldRenderer(GameManager manager, String world, EJGEngine e) {
        this.world = manager.getGameRegister().getWorld(world);
        this.gameManager = manager;
        this.engine = e;
    }

    public void renderWorldChunks() {
        for (Chunk chunk : this.world.getChunks()) {
            this.engine.getRenderers().getCameraRenderer().renderObjects(chunk.getTiles());
        }
    }

    public void renderWorldChunksAsBatch() {
        ArrayList<Chunk> chunksSnapshot = new ArrayList<Chunk>(this.world.getChunks());
        for (Chunk chunk : chunksSnapshot) {
            Entity obj;
            this.engine.getRenderers().getCameraRenderer().renderBatchObjects(chunk.getTilesAsMap());
            if (this.gameManager.getGameRegister().getPlayers() == null) {
                return;
            }
            Iterator<Entity> iterator = this.gameManager.getGameRegister().getPlayers().iterator();
            while (iterator.hasNext()) {
                Player player;
                obj = player = iterator.next();
                this.engine.getRenderers().getCameraRenderer().renderObject(obj);
            }
            for (Entity entity : this.gameManager.getGameRegister().getEntitys()) {
                obj = entity;
                this.engine.getRenderers().getCameraRenderer().renderObject(obj);
            }
        }
    }

    public void renderChunkRelativeToCamera(Chunk chunk) {
        this.engine.getRenderers().getCameraRenderer().renderObjects(chunk.getTiles());
    }
}

