/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.client.gui.graphics.renderer.ui;

import org.collebol.client.EJGEngine;
import org.collebol.client.gui.graphics.Text;
import org.collebol.client.gui.graphics.renderer.Renderer;
import org.collebol.client.gui.graphics.ui.component.Field;
import org.collebol.client.gui.graphics.ui.component.TextInput;
import org.collebol.shared.math.Vector2D;
import org.lwjgl.opengl.GL11;

public class TextInputRenderer
extends Renderer {
    private final EJGEngine engine;

    public TextInputRenderer(EJGEngine engine) {
        this.engine = engine;
    }

    public void renderTextInput(int id) {
        this.renderTextInputInternal(id, 0.0f, 0.0f);
    }

    public void renderSubTextInput(int id, int parentId) {
        Field parent = (Field)this.engine.getComponentHandler().getComponent(Field.class, parentId);
        this.renderTextInputInternal(id, parent.getPosition().getX(), parent.getPosition().getY());
    }

    private void renderTextInputInternal(int id, float offsetX, float offsetY) {
        Text text;
        TextInput input = (TextInput)this.engine.getComponentHandler().getComponent(TextInput.class, id);
        GL11.glDisable(2896);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        float x = input.getPosition().getX() + offsetX;
        float y = input.getPosition().getY() + offsetY;
        float width = input.getWidth();
        float height = input.getHeight();
        GL11.glBegin(7);
        GL11.glColor4fv(input.getBackgroundColor());
        GL11.glVertex2f(x, y);
        GL11.glVertex2f(x, y + height);
        GL11.glVertex2f(x + width, y + height);
        GL11.glVertex2f(x + width, y);
        GL11.glEnd();
        if (input.getBorderSize() > 0.0f) {
            GL11.glLineWidth(input.getBorderSize());
            GL11.glColor4fv(input.getBorderColor());
            GL11.glBegin(2);
            GL11.glVertex2f(x, y);
            GL11.glVertex2f(x, y + height);
            GL11.glVertex2f(x + width, y + height);
            GL11.glVertex2f(x + width, y);
            GL11.glEnd();
        }
        if ((text = input.getText()) != null) {
            float textX = x + 5.0f;
            float textY = y + height / 2.0f - text.getSize() / 2.0f;
            this.engine.getRenderers().getTextRenderer("default").render(new Text(new Text.TextBuilder().text(text.getText()).position(new Vector2D(textX, textY)).align(text.getAlign()).scale(text.getScale()).size(text.getSize()).rotation(text.getRotation())));
            if (input.isFocused()) {
                int cursorPos = input.getCursorPosition();
                float cursorX = textX + (float)cursorPos * text.getSize() * 0.6f;
                GL11.glLineWidth(1.0f);
                GL11.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
                GL11.glBegin(1);
                GL11.glVertex2f(cursorX, y + 3.0f);
                GL11.glVertex2f(cursorX, y + height - 3.0f);
                GL11.glEnd();
            }
        }
    }
}

