/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.shared.physics.collision;

import org.collebol.shared.GameLocation;
import org.collebol.shared.objects.GameObject;
import org.collebol.shared.physics.collision.Collider;

public class BoxCollider
extends Collider {
    private double width;
    private double height;

    public BoxCollider(GameObject owner, GameLocation originLocation, double width, double height) {
        super(owner, originLocation);
        this.width = width;
        this.height = height;
    }

    @Override
    public boolean intersects(Collider other) {
        if (other instanceof BoxCollider) {
            GameLocation bOrigin;
            BoxCollider o = (BoxCollider)other;
            double ax = this.getLocation().getX();
            double ay = this.getLocation().getY();
            double bx = o.getLocation().getX();
            double by = o.getLocation().getY();
            GameLocation aOrigin = this.getOriginLocation();
            if (aOrigin == null) {
                aOrigin = new GameLocation(0.0, 0.0);
            }
            if ((bOrigin = o.getOriginLocation()) == null) {
                bOrigin = new GameLocation(0.0, 0.0);
            }
            return (ax -= aOrigin.getX()) < (bx -= bOrigin.getX()) + o.width && ax + this.width > bx && (ay -= aOrigin.getY()) < (by -= bOrigin.getY()) + o.height && ay + this.height > by;
        }
        return false;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }
}

