/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiPropertyStore")
public class AIPropertyStore
extends Struct<AIPropertyStore>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SENTINEL;

    protected AIPropertyStore(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected AIPropertyStore create(long address, @Nullable ByteBuffer container) {
        return new AIPropertyStore(address, container);
    }

    public AIPropertyStore(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIPropertyStore.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char")
    public byte sentinel() {
        return AIPropertyStore.nsentinel(this.address());
    }

    public AIPropertyStore sentinel(@NativeType(value="char") byte value) {
        AIPropertyStore.nsentinel(this.address(), value);
        return this;
    }

    public AIPropertyStore set(AIPropertyStore src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIPropertyStore malloc() {
        return new AIPropertyStore(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static AIPropertyStore calloc() {
        return new AIPropertyStore(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static AIPropertyStore create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new AIPropertyStore(MemoryUtil.memAddress(container), container);
    }

    public static AIPropertyStore create(long address) {
        return new AIPropertyStore(address, null);
    }

    public static @Nullable AIPropertyStore createSafe(long address) {
        return address == 0L ? null : new AIPropertyStore(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(AIPropertyStore.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIPropertyStore.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIPropertyStore mallocStack() {
        return AIPropertyStore.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIPropertyStore callocStack() {
        return AIPropertyStore.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIPropertyStore mallocStack(MemoryStack stack) {
        return AIPropertyStore.malloc(stack);
    }

    @Deprecated
    public static AIPropertyStore callocStack(MemoryStack stack) {
        return AIPropertyStore.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIPropertyStore.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIPropertyStore.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIPropertyStore.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIPropertyStore.calloc(capacity, stack);
    }

    public static AIPropertyStore malloc(MemoryStack stack) {
        return new AIPropertyStore(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIPropertyStore calloc(MemoryStack stack) {
        return new AIPropertyStore(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte nsentinel(long struct) {
        return MemoryUtil.memGetByte(struct + (long)SENTINEL);
    }

    public static void nsentinel(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)SENTINEL, value);
    }

    static {
        Struct.Layout layout = AIPropertyStore.__struct(AIPropertyStore.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SENTINEL = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<AIPropertyStore, Buffer>
    implements NativeResource {
        private static final AIPropertyStore ELEMENT_FACTORY = AIPropertyStore.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected AIPropertyStore getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char")
        public byte sentinel() {
            return AIPropertyStore.nsentinel(this.address());
        }

        public Buffer sentinel(@NativeType(value="char") byte value) {
            AIPropertyStore.nsentinel(this.address(), value);
            return this;
        }
    }
}

