package org.collebol.client.event.client.button;

import org.collebol.client.event.ClientEvent;
import org.collebol.client.gui.graphics.ui.Component;
import org.collebol.client.gui.graphics.ui.component.Button;
import org.collebol.shared.math.Vector2D;

import java.util.Map;

public class ClientButtonHoverEvent extends ClientEvent {

    private Vector2D position;
    private Button button;
    private boolean entered;

    public ClientButtonHoverEvent() {
    }

    public ClientButtonHoverEvent(Vector2D position, Button button, boolean entered) {
        this.position = position;
        this.button = button;
        this.entered = entered;
    }

    public Vector2D getPosition() {
        return position;
    }

    public Button getButton() {
        return button;
    }

    public boolean isEnter() {
        return entered;
    }

    public boolean isExit() {
        return !entered;
    }

    @Override
    public void setValues(Map<Class<?>, Object> params) {
        position = (Vector2D) params.get(Vector2D.class);
        button = (Button) params.get(Component.class);
        entered = (boolean) params.get(Boolean.class);
    }
}
