package org.collebol.shared;

import org.collebol.shared.math.Vector2D;

/**
 * EngineObject represents an object in the game engine,
 * holding its position (as a Vector2D) and texture (for visual representation).
 *
 * @author ColleBol - <a href="mailto:contact@collebol.org">contact@collebol.org</a>
 * @since 1.0-dev
 */
public class EngineObject {

    private Vector2D vector;
    private int textureid;
    private Sprite sprite;
    private Vector2D originPosition;

    /**
     * Position relative to the screen.
     *
     * @return position as vector
     */
    public Vector2D getVector() {
        return vector;
    }

    /**
     * Position relative to the screen.
     *
     * @param vector set the screen position of the object.
     */
    public void setVector(Vector2D vector) {
        this.vector = vector;
    }

    public int getTexture() {
        return this.textureid;
    }

    public void setTexture(int id) {
        this.textureid = id;
    }

    public Sprite getSprite() {
        return sprite;
    }

    public void setSprite(Sprite sprite) {
        this.sprite = sprite;
    }

    public boolean hasSprite() {
        return this.sprite != null;
    }

    public Vector2D getOriginPosition() {
        return originPosition;
    }

    public void setOriginPosition(Vector2D originPosition) {
        this.originPosition = originPosition;
    }
}
