/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.client.gui.graphics.renderer.ui;

import org.collebol.client.EJGEngine;
import org.collebol.client.gui.graphics.Text;
import org.collebol.client.gui.graphics.renderer.Renderer;
import org.collebol.client.gui.graphics.ui.component.Button;
import org.collebol.client.gui.graphics.ui.component.Field;
import org.collebol.shared.math.Vector2D;
import org.lwjgl.opengl.GL11;

public class ButtonRenderer
extends Renderer {
    private final EJGEngine engine;

    public ButtonRenderer(EJGEngine engine) {
        this.engine = engine;
    }

    public void renderButton(int id) {
        Text text;
        Button button = (Button)this.engine.getComponentHandler().getComponent(Button.class, id);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float x = button.getPosition().getX();
        float y = button.getPosition().getY();
        float width = button.getWidth();
        float height = button.getHeight();
        float borderSize = button.getBorderSize();
        float[] borderColor = button.getBorderColor();
        GL11.glBegin((int)7);
        GL11.glColor4fv((float[])button.getBackgroundColor());
        GL11.glVertex2f((float)x, (float)y);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
        if (borderSize > 0.0f) {
            GL11.glLineWidth((float)borderSize);
            GL11.glColor4fv((float[])borderColor);
            GL11.glBegin((int)2);
            GL11.glVertex2f((float)x, (float)y);
            GL11.glVertex2f((float)x, (float)(y + height));
            GL11.glVertex2f((float)(x + width), (float)(y + height));
            GL11.glVertex2f((float)(x + width), (float)y);
            GL11.glEnd();
        }
        if ((text = button.getText()) == null) {
            return;
        }
        text.setPosition(new Vector2D(text.getPosition().getX() + x, text.getPosition().getY() + y));
        this.engine.getRenderers().getTextRenderer("default").render(new Text(new Text.TextBuilder().text(text.getText()).position(new Vector2D(text.getPosition().getX() + x, text.getPosition().getY() + y)).align(text.getAlign()).scale(text.getScale()).size(text.getSize()).rotation(text.getRotation())));
    }

    public void renderSubButton(int id, int parentId) {
        Text text;
        Field parent = (Field)this.engine.getComponentHandler().getComponent(Field.class, parentId);
        Button button = (Button)parent.subComponents().getComponent(Button.class, id);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float x = button.getPosition().getX() + parent.getPosition().getX();
        float y = button.getPosition().getY() + parent.getPosition().getY();
        float width = button.getWidth();
        float height = button.getHeight();
        float borderSize = button.getBorderSize();
        float[] borderColor = button.getBorderColor();
        GL11.glBegin((int)7);
        GL11.glColor4fv((float[])button.getBackgroundColor());
        GL11.glVertex2f((float)x, (float)y);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
        if (borderSize > 0.0f) {
            GL11.glLineWidth((float)borderSize);
            GL11.glColor4fv((float[])borderColor);
            GL11.glBegin((int)2);
            GL11.glVertex2f((float)x, (float)y);
            GL11.glVertex2f((float)x, (float)(y + height));
            GL11.glVertex2f((float)(x + width), (float)(y + height));
            GL11.glVertex2f((float)(x + width), (float)y);
            GL11.glEnd();
        }
        if ((text = button.getText()) == null) {
            return;
        }
        this.engine.getRenderers().getTextRenderer("default").render(new Text(new Text.TextBuilder().text(text.getText()).position(new Vector2D(text.getPosition().getX() + x, text.getPosition().getY() + y)).align(text.getAlign()).scale(text.getScale()).size(text.getSize()).rotation(text.getRotation())));
    }
}

