/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.client.gui.graphics.renderer.ui;

import java.util.HashMap;
import java.util.Map;
import org.collebol.client.EJGEngine;
import org.collebol.client.gui.graphics.renderer.Renderer;
import org.collebol.client.gui.graphics.renderer.TextRenderer;
import org.collebol.client.gui.graphics.renderer.ui.ButtonRenderer;
import org.collebol.client.gui.graphics.renderer.ui.FieldRenderer;
import org.collebol.client.gui.graphics.renderer.ui.TextInputRenderer;
import org.collebol.client.gui.graphics.ui.Component;
import org.collebol.client.gui.graphics.ui.component.Button;
import org.collebol.client.gui.graphics.ui.component.Field;
import org.collebol.client.gui.graphics.ui.component.TextInput;

public class UIRenderer
extends Renderer {
    private final EJGEngine engine;
    private Map<Class<? extends Renderer>, Renderer> UIRenderers;

    public void addUIRenderers() {
        this.UIRenderers.put(FieldRenderer.class, new FieldRenderer(this.engine));
        this.UIRenderers.put(ButtonRenderer.class, new ButtonRenderer(this.engine));
        this.UIRenderers.put(TextInputRenderer.class, new TextInputRenderer(this.engine));
    }

    public UIRenderer(EJGEngine e) {
        this.engine = e;
        this.UIRenderers = new HashMap<Class<? extends Renderer>, Renderer>();
        this.addUIRenderers();
    }

    public <T extends Class<? extends Component>> void renderComponent(T cls, int id) {
        Renderer renderer;
        if (cls == Field.class) {
            renderer = (FieldRenderer)this.UIRenderers.get(FieldRenderer.class);
            ((FieldRenderer)renderer).renderField(id);
        }
        if (cls == Button.class) {
            renderer = (ButtonRenderer)this.UIRenderers.get(ButtonRenderer.class);
            ((ButtonRenderer)renderer).renderButton(id);
        }
        if (cls == TextInput.class) {
            renderer = (TextInputRenderer)this.UIRenderers.get(TextInputRenderer.class);
            ((TextInputRenderer)renderer).renderTextInput(id);
        }
    }

    public <T extends Class<? extends Component>> void renderSubComponent(T cls, int id, int fieldId) {
        Renderer renderer;
        if (cls == Field.class) {
            renderer = (FieldRenderer)this.UIRenderers.get(FieldRenderer.class);
            ((FieldRenderer)renderer).renderSubField(id, fieldId);
        }
        if (cls == Button.class) {
            renderer = (ButtonRenderer)this.UIRenderers.get(ButtonRenderer.class);
            ((ButtonRenderer)renderer).renderSubButton(id, fieldId);
        }
        if (cls == TextInput.class) {
            renderer = (TextInputRenderer)this.UIRenderers.get(TextRenderer.class);
            ((TextInputRenderer)renderer).renderSubTextInput(id, fieldId);
        }
    }
}

