/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.game;

import org.collebol.game.GameRegister;

public abstract class GameManager
implements Runnable {
    private int ticks = 20;
    private Thread thread;
    private GameRegister gameRegister = new GameRegister();

    public void startGameThread() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stopGameThread() {
        this.thread = null;
    }

    @Override
    public void run() {
        double drawInterval = 1.0E9 / (double)this.getTicks();
        double delta = 0.0;
        long lastTime = System.nanoTime();
        while (this.thread != null) {
            long currentTime = System.nanoTime();
            delta += (double)(currentTime - lastTime) / drawInterval;
            lastTime = currentTime;
            if (!(delta >= 1.0)) continue;
            this.update();
            delta -= 1.0;
        }
    }

    public abstract void update();

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public void setGameRegister(GameRegister gameRegister) {
        this.gameRegister = gameRegister;
    }

    public GameRegister getGameRegister() {
        if (this.gameRegister == null) {
            throw new RuntimeException("Please, set a GameRegister before using!");
        }
        return this.gameRegister;
    }
}

