/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.game;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.collebol.game.world.World;
import org.collebol.shared.objects.entity.Entity;
import org.collebol.shared.objects.entity.Player;
import org.collebol.shared.physics.PhysicsManager;

public class GameRegister {
    private Map<UUID, Player> players = new HashMap<UUID, Player>();
    private Map<UUID, Entity> entitys = new HashMap<UUID, Entity>();
    private Map<String, World> worlds = new HashMap<String, World>();
    private PhysicsManager physicsManager = new PhysicsManager();

    public void registerPlayer(Player player) {
        if (player == null) {
            throw new RuntimeException("Player can not be null!");
        }
        if (player.getUuid() == null) {
            throw new RuntimeException("Please make sure to set the player UUID!");
        }
        this.players.put(player.getUuid(), player);
        this.physicsManager.register(player);
    }

    public Player getPlayer(UUID uuid) {
        if (uuid == null) {
            throw new RuntimeException("UUID can not be null!");
        }
        if (!this.players.containsKey(uuid)) {
            throw new RuntimeException("UUID or Player not found!");
        }
        return this.players.get(uuid);
    }

    public List<Player> getPlayers() {
        if (this.players.isEmpty()) {
            return new ArrayList<Player>();
        }
        return new ArrayList<Player>(this.players.values());
    }

    public Player removePlayer(UUID uuid) {
        if (uuid == null) {
            throw new RuntimeException("UUID can not be null!");
        }
        return this.players.remove(uuid);
    }

    public void registerEntity(Entity entity) {
        if (entity instanceof Player) {
            throw new RuntimeException("To register a player use the registerPlayer() method!");
        }
        if (entity == null || entity.getUuid() == null) {
            throw new RuntimeException("Entity values can not be null!");
        }
        this.entitys.put(entity.getUuid(), entity);
        this.physicsManager.register(entity);
    }

    public Entity getEntity(UUID uuid) {
        if (uuid == null) {
            throw new RuntimeException("UUID can not be null!");
        }
        if (!this.players.containsKey(uuid)) {
            throw new RuntimeException("UUID or Entity not found!");
        }
        return this.players.get(uuid);
    }

    public List<Entity> getEntitys() {
        if (this.entitys.isEmpty()) {
            return new ArrayList<Entity>();
        }
        return new ArrayList<Entity>(this.entitys.values());
    }

    public Entity removeEntity(UUID uuid) {
        if (uuid == null) {
            throw new RuntimeException("UUID can not be null!");
        }
        return this.entitys.remove(uuid);
    }

    public void registerWorld(World world) {
        if (world == null || world.getName() == null) {
            throw new RuntimeException("World values can not be null!");
        }
        if (this.worlds.containsKey(world.getName())) {
            throw new RuntimeException("This world is already registered!");
        }
        this.worlds.put(world.getName(), world);
    }

    public World getWorld(String name) {
        if (name == null) {
            throw new RuntimeException("World name can not be null!");
        }
        if (!this.worlds.containsKey(name)) {
            throw new RuntimeException("World not found or does not exists!");
        }
        return this.worlds.get(name);
    }

    public World removeWorld(String name) {
        if (name == null) {
            throw new RuntimeException("World name can not be null!");
        }
        if (!this.worlds.containsKey(name)) {
            throw new RuntimeException("Removable world not found!");
        }
        return this.worlds.remove(name);
    }

    public PhysicsManager getPhysicsManager() {
        return this.physicsManager;
    }
}

