/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.game.world;

import org.collebol.game.world.Chunk;
import org.collebol.game.world.World;
import org.collebol.shared.GameLocation;

public abstract class WorldGenerator {
    private World world;

    public WorldGenerator(World world) {
        this.world = world;
    }

    public abstract Chunk generateChunk(Chunk var1);

    public void generateRenderDistanceIfNotExists(GameLocation location) {
        Chunk tempChunk = null;
        try {
            tempChunk = (Chunk)this.world.getChunkFormat().getConstructor(Integer.TYPE, Integer.TYPE).newInstance(0, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        int chunkSize = tempChunk.getChunkSize();
        int centerChunkX = (int)location.getX() / chunkSize;
        int centerChunkY = (int)location.getY() / chunkSize;
        for (int x = centerChunkX - this.world.getWorldLoader().getRenderDistance(); x <= centerChunkX + this.world.getWorldLoader().getRenderDistance(); ++x) {
            for (int y = centerChunkY - this.world.getWorldLoader().getRenderDistance(); y <= centerChunkY + this.world.getWorldLoader().getRenderDistance(); ++y) {
                Chunk existingChunk = this.world.getWorldFileManager().loadChunk(x, y);
                if (existingChunk != null) continue;
                try {
                    Chunk newChunk = (Chunk)this.world.getChunkFormat().getConstructor(Integer.TYPE, Integer.TYPE).newInstance(x, y);
                    newChunk = this.generateChunk(newChunk);
                    this.world.getWorldFileManager().saveChunk(newChunk);
                    this.world.addChunk(newChunk);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

