/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.game.world;

import java.util.ArrayList;
import java.util.List;
import org.collebol.game.world.Chunk;
import org.collebol.game.world.World;
import org.collebol.shared.GameLocation;

public class WorldLoader {
    private World world;
    private int renderDistance;

    public WorldLoader(World world, int renderDistance) {
        this.world = world;
        this.renderDistance = renderDistance;
    }

    public List<Chunk> loadRenderDistanceChunkFileFromLocation(GameLocation gameLocation) {
        Chunk chunk = null;
        try {
            chunk = (Chunk)this.world.getChunkFormat().getConstructor(Integer.TYPE, Integer.TYPE).newInstance(0, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int minChunkX = (int)gameLocation.getX() / chunk.getChunkSize() - this.renderDistance;
        int maxChunkX = (int)gameLocation.getX() / chunk.getChunkSize() + this.renderDistance;
        int minChunkY = (int)gameLocation.getY() / chunk.getChunkSize() - this.renderDistance;
        int maxChunkY = (int)gameLocation.getY() / chunk.getChunkSize() + this.renderDistance;
        ArrayList<Chunk> chunkList = new ArrayList<Chunk>();
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                if (this.world.getWorldFileManager().loadChunk(chunkX, chunkY) == null) continue;
                Chunk cChunk = this.world.getWorldFileManager().loadChunk(chunkX, chunkY);
                chunkList.add(cChunk);
            }
        }
        return chunkList;
    }

    public void loadMissingChunksInRenderDistance(GameLocation location) {
        Chunk tempChunk = null;
        try {
            tempChunk = (Chunk)this.world.getChunkFormat().getConstructor(Integer.TYPE, Integer.TYPE).newInstance(0, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        int chunkSize = tempChunk.getChunkSize();
        int centerChunkX = (int)location.getX() / chunkSize;
        int centerChunkY = (int)location.getY() / chunkSize;
        int minChunkX = centerChunkX - this.renderDistance;
        int maxChunkX = centerChunkX + this.renderDistance;
        int minChunkY = centerChunkY - this.renderDistance;
        int maxChunkY = centerChunkY + this.renderDistance;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                if (this.world.getChunk(chunkX, chunkY) != null) continue;
                try {
                    Chunk loadedChunk = this.world.getWorldFileManager().loadChunk(chunkX, chunkY);
                    if (loadedChunk == null) continue;
                    this.world.addChunk(loadedChunk);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList<Chunk> chunksToRemove = new ArrayList<Chunk>();
        for (Chunk chunk : this.world.getChunks()) {
            int x = chunk.getX();
            int y = chunk.getY();
            if (x >= minChunkX && x <= maxChunkX && y >= minChunkY && y <= maxChunkY) continue;
            chunksToRemove.add(chunk);
        }
        for (Chunk chunk : chunksToRemove) {
            this.world.getChunks().remove(chunk);
        }
    }

    public int getRenderDistance() {
        return this.renderDistance;
    }

    public void setRenderDistance(int renderDistance) {
        this.renderDistance = renderDistance;
    }
}

