/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.shared;

import java.util.ArrayList;
import java.util.List;

public class Sprite {
    private List<Integer> frameIds;
    private float frameDuration;
    private int currentFrame;
    private float elapsedTime;

    public Sprite(SpriteBuilder builder) {
        this.frameIds = builder.frameIds;
        this.frameDuration = builder.frameDuration;
        this.currentFrame = builder.currentFrame;
        this.elapsedTime = builder.elapsedTime;
    }

    public void update(float deltaTime) {
        this.elapsedTime += deltaTime;
        if (this.elapsedTime >= this.frameDuration) {
            this.elapsedTime -= this.frameDuration;
            this.currentFrame = (this.currentFrame + 1) % this.frameIds.size();
        }
    }

    public float getElapsedTime() {
        return this.elapsedTime;
    }

    public int getCurrentFrameId() {
        if (this.frameIds == null || this.frameIds.isEmpty()) {
            throw new IllegalStateException("Sprite has no frames! Call SpriteBuilder.frames(...) first.");
        }
        return this.frameIds.get(this.currentFrame % this.frameIds.size());
    }

    public float getFrameDuration() {
        return this.frameDuration;
    }

    public List<Integer> getFrameIds() {
        return this.frameIds;
    }

    public static class SpriteBuilder {
        private List<Integer> frameIds;
        private float frameDuration = 1.0f;
        private int currentFrame = 0;
        private float elapsedTime = 0.0f;

        public SpriteBuilder frames(int[] IDs) {
            this.frameIds = new ArrayList<Integer>();
            for (int id : IDs) {
                this.frameIds.add(id);
            }
            return this;
        }

        public SpriteBuilder duration(float duration) {
            this.frameDuration = duration;
            return this;
        }

        public SpriteBuilder current(int current) {
            this.currentFrame = current;
            return this;
        }

        public SpriteBuilder elapsed(float elapsed) {
            this.elapsedTime = elapsed;
            return this;
        }
    }
}

