/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.shared.physics;

import java.util.ArrayList;
import java.util.List;
import org.collebol.shared.GameLocation;
import org.collebol.shared.objects.GameObject;
import org.collebol.shared.physics.PhysicsComponent;
import org.collebol.shared.physics.collision.BoxCollider;

public class PhysicsManager {
    private final List<GameObject> objects = new ArrayList<GameObject>();

    public void register(GameObject object) {
        if (!this.objects.contains(object)) {
            this.objects.add(object);
        }
    }

    public boolean tryMove(GameObject object, GameLocation newLoc) {
        GameLocation loc = object.getGameLocation();
        double oldX = loc.getX();
        double oldY = loc.getY();
        loc.setX(newLoc.getX());
        loc.setY(newLoc.getY());
        for (GameObject other : this.objects) {
            if (other == object) continue;
            for (PhysicsComponent comp : object.getPhysicsComponentsList()) {
                if (!(comp instanceof BoxCollider)) continue;
                for (PhysicsComponent otherComp : other.getPhysicsComponentsList()) {
                    if (!(otherComp instanceof BoxCollider) || !((BoxCollider)comp).intersects((BoxCollider)otherComp)) continue;
                    loc.setX(oldX);
                    loc.setY(oldY);
                    return false;
                }
            }
        }
        return true;
    }
}

