/*
 * Decompiled with CFR 0.152.
 */
package org.collebol;

import java.util.HashMap;
import java.util.Map;
import org.collebol.EJGEngine;
import org.collebol.gui.graphics.renderer.CameraRenderer;
import org.collebol.gui.graphics.renderer.Renderer;
import org.collebol.gui.graphics.renderer.TextRenderer;
import org.collebol.gui.graphics.renderer.TextureRenderer;

public class RenderRegisterHandler {
    private EJGEngine engine;
    private Map<String, TextRenderer> textRenderers;
    private Map<String, TextureRenderer> textureRenderers;
    private CameraRenderer cameraRenderer;

    public RenderRegisterHandler(EJGEngine e) {
        this.engine = e;
        this.textRenderers = new HashMap<String, TextRenderer>();
        this.textureRenderers = new HashMap<String, TextureRenderer>();
    }

    public <T extends Renderer> void registerNewRenderer(T renderer) {
        if (renderer instanceof TextRenderer) {
            this.textRenderers.put(((TextRenderer)renderer).getName(), (TextRenderer)renderer);
            ((TextRenderer)renderer).setup();
        }
        if (renderer instanceof TextureRenderer) {
            this.textureRenderers.put(((TextureRenderer)renderer).getName(), (TextureRenderer)renderer);
        }
        if (renderer instanceof CameraRenderer) {
            this.cameraRenderer = (CameraRenderer)renderer;
        }
    }

    public void registerTextureRenderer(TextureRenderer renderer) {
        this.textureRenderers.put(renderer.getName(), renderer);
    }

    public TextRenderer getTextRenderer(String name) {
        if (this.textRenderers.isEmpty()) {
            throw new RuntimeException("You are trying to display text, you have not set a TextRenderer yet. Please, register a TextRenderer in the register() method!");
        }
        if (name == "default" && !this.textRenderers.containsKey(name)) {
            throw new RuntimeException("Please, register a Default font in the register() method with the name 'default'.");
        }
        if (this.textRenderers.get(name) != null) {
            return this.textRenderers.get(name);
        }
        throw new RuntimeException("TextRender not found: " + name);
    }

    public TextureRenderer getTextureRenderer(String name) {
        if (this.textureRenderers.isEmpty()) {
            throw new RuntimeException("You are trying to display a Texture but you have not set a TextureRenderer yet. Please, register a TextureRenderer in the register() method!");
        }
        if (this.textureRenderers.get(name) != null) {
            return this.textureRenderers.get(name);
        }
        throw new RuntimeException("TextureRenderer not found: " + name);
    }

    public CameraRenderer getCameraRenderer() {
        if (this.cameraRenderer == null) {
            throw new RuntimeException("You are trying to display something relative to your Camera using the CameraRenderer, but you have not set a CameraRenderer yet. Please, register a CameraRenderer in the register() method!");
        }
        return this.cameraRenderer;
    }
}

