/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.game;

import org.collebol.EJGEngine;
import org.collebol.game.objects.entity.Player;

public abstract class GameManager
implements Runnable {
    private EJGEngine engine;
    private int ticks = 20;
    private Player player;
    private Thread thread;

    public GameManager(EJGEngine engine) {
        this.engine = engine;
    }

    public void startGameThread() {
        this.thread = new Thread();
        this.thread.start();
    }

    @Override
    public void run() {
        double drawInterval = 1.0E9 / (double)this.getTicks();
        double delta = 0.0;
        long lastTime = System.nanoTime();
        while (this.thread != null) {
            long currentTime = System.nanoTime();
            delta += (double)(currentTime - lastTime) / drawInterval;
            lastTime = currentTime;
            if (!(delta >= 1.0)) continue;
            this.update();
            delta -= 1.0;
        }
    }

    public abstract void update();

    public EJGEngine getEngine() {
        return this.engine;
    }

    public void setEngine(EJGEngine engine) {
        this.engine = engine;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }
}

