/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.game.world;

import java.util.ArrayList;
import java.util.List;
import org.collebol.game.GameObject;

public abstract class Chunk {
    private int chunkSize;
    private int x;
    private int y;
    private List<GameObject> tiles;
    private List<GameObject> entities;

    public Chunk(int chunkSize, int x, int y) {
        this.chunkSize = chunkSize;
        this.x = x;
        this.y = y;
        this.tiles = new ArrayList<GameObject>();
        this.entities = new ArrayList<GameObject>();
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void addTile(GameObject tile) {
        if (tile.getGameLocation() == null) {
            throw new RuntimeException("Tile GameLocation is null. Please, set a location.");
        }
        this.tiles.add(tile);
    }

    public void addEntity(GameObject entity) {
        if (entity.getGameLocation() == null) {
            throw new RuntimeException("Entity GameLocation is null. Please, set a location.");
        }
        this.entities.add(entity);
    }

    public List<GameObject> getTiles() {
        return this.tiles;
    }

    public List<GameObject> getEntities() {
        return this.entities;
    }
}

