/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.gui.graphics.renderer;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.collebol.EJGEngine;
import org.collebol.gui.graphics.Light;
import org.collebol.gui.graphics.Texture;
import org.collebol.gui.graphics.renderer.Renderer;
import org.collebol.math.Vector2D;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class TextureRenderer
implements Renderer {
    private String name;
    private EJGEngine engine;
    private float width;
    private float height;
    private Map<Integer, Texture> textures = new HashMap<Integer, Texture>();
    private List<Light> lights = new ArrayList<Light>();

    private EJGEngine getEngine() {
        return this.engine;
    }

    public TextureRenderer(String name, float width, float height, EJGEngine e) {
        this.name = name;
        this.engine = e;
        this.width = width;
        this.height = height;
    }

    public TextureRenderer(String name, EJGEngine e) {
        this.name = name;
        this.engine = e;
        this.width = e.getWindow().getTileSize();
        this.height = e.getWindow().getTileSize();
    }

    public void render(int index, Vector2D position, float scale, float rotation, Vector2D origin, boolean lighting) {
        if (lighting) {
            GL11.glEnable((int)2896);
        } else {
            GL11.glDisable((int)2896);
        }
        Texture texture = this.getTexture(index);
        texture.bind();
        float startX = position.getX();
        float startY = position.getY();
        float tWidth = this.width * scale;
        float tHeight = this.height * scale;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)origin.getX(), (float)origin.getY(), (float)0.0f);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-origin.getX()), (float)(-origin.getY()), (float)0.0f);
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3553);
        GL11.glBegin((int)7);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)startX, (float)startY);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)startX, (float)(startY + tHeight));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(startX + tWidth), (float)(startY + tHeight));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(startX + tWidth), (float)startY);
        GL11.glEnd();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void applyLight(int index, Light light, float scale, float[] ambientColor) {
        GL11.glEnable((int)2896);
        GL11.glEnable((int)(16384 + index));
        float lightX = light.getPosition().getX();
        float lightY = light.getPosition().getY();
        FloatBuffer lightPos = BufferUtils.createFloatBuffer((int)4);
        lightPos.put(new float[]{lightX, lightY, light.getRadius() * scale, 1.0f});
        lightPos.flip();
        GL11.glLightfv((int)(16384 + index), (int)4611, (FloatBuffer)lightPos);
        FloatBuffer lightColor = BufferUtils.createFloatBuffer((int)4);
        lightColor.put(light.getColor());
        lightColor.flip();
        GL11.glLightfv((int)(16384 + index), (int)4609, (FloatBuffer)lightColor);
        FloatBuffer ambientCl = BufferUtils.createFloatBuffer((int)4);
        ambientCl.put(ambientColor);
        ambientCl.flip();
        GL11.glLightfv((int)(16384 + index), (int)4608, (FloatBuffer)ambientCl);
    }

    public void registerTexture(Texture texture) {
        this.textures.put(texture.getIndex(), texture);
    }

    public Texture getTexture(int index) {
        if (this.textures.get(index) == null) {
            throw new RuntimeException("Invalid Index of textures: " + index + ". Register Texture before using!");
        }
        return this.textures.get(index);
    }

    public String getName() {
        return this.name;
    }
}

