/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.input;

import org.collebol.EJGEngine;
import org.collebol.event.client.ClientLeftClickEvent;
import org.collebol.event.client.ClientRightClickEvent;
import org.collebol.gui.graphics.Camera;
import org.collebol.math.Vector2D;
import org.collebol.utils.GameLocation;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;

public class MouseHandler {
    private boolean leftPressed;
    private boolean rightPressed;
    private Vector2D position = new Vector2D(0.0f, 0.0f);
    private EJGEngine engine;

    public MouseHandler(EJGEngine e) {
        this.engine = e;
    }

    public void registerCallbacks(long window) {
        GLFW.glfwSetMouseButtonCallback((long)window, (GLFWMouseButtonCallbackI)new GLFWMouseButtonCallback(){

            public void invoke(long window, int button, int action, int mods) {
                if (button == 0) {
                    boolean bl = MouseHandler.this.leftPressed = action == 1;
                    if (action == 1) {
                        MouseHandler.this.engine.getEventHandler().callClientEvent(ClientLeftClickEvent.class).call(MouseHandler.this.engine, true, MouseHandler.this.position);
                    } else {
                        MouseHandler.this.engine.getEventHandler().callClientEvent(ClientLeftClickEvent.class).call(MouseHandler.this.engine, false, MouseHandler.this.position);
                    }
                }
                if (button == 1) {
                    boolean bl = MouseHandler.this.rightPressed = action == 1;
                    if (action == 1) {
                        MouseHandler.this.engine.getEventHandler().callClientEvent(ClientRightClickEvent.class).call(MouseHandler.this.engine, true, MouseHandler.this.position);
                    } else if (action == 0) {
                        MouseHandler.this.engine.getEventHandler().callClientEvent(ClientRightClickEvent.class).call(MouseHandler.this.engine, false, MouseHandler.this.position);
                    }
                }
            }
        });
        GLFW.glfwSetCursorPosCallback((long)window, (GLFWCursorPosCallbackI)new GLFWCursorPosCallback(){

            public void invoke(long window, double xpos, double ypos) {
                MouseHandler.this.position.setX((float)xpos);
                MouseHandler.this.position.setY((float)ypos);
            }
        });
    }

    public boolean isLeftPressed() {
        return this.leftPressed;
    }

    public void setLeftPressed(boolean leftPressed) {
        this.leftPressed = leftPressed;
    }

    public boolean isRightPressed() {
        return this.rightPressed;
    }

    public void setRightPressed(boolean rightPressed) {
        this.rightPressed = rightPressed;
    }

    public Vector2D getPosition() {
        return this.position;
    }

    public void setPosition(Vector2D position) {
        this.position = position;
    }

    public GameLocation getGameLocation() {
        Camera camera = this.engine.getWindow().getCurrentPanel().getCamera();
        GameLocation location = camera.calculate().getGameLocationFromVector2D(this.position);
        float x = (this.position.getX() + camera.getPosition().getX() - camera.getOrigin().getX()) / ((float)this.engine.getWindow().getTileSize() * camera.getZoom());
        float y = (this.position.getY() + camera.getPosition().getY() - camera.getOrigin().getY()) / ((float)this.engine.getWindow().getTileSize() * camera.getZoom());
        Vector2D v = new Vector2D(x, y);
        return location;
    }
}

