/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.math;

import org.collebol.EJGEngine;
import org.collebol.gui.graphics.Camera;
import org.collebol.math.Vector2D;
import org.collebol.utils.GameLocation;

public class CameraCalculator {
    private Camera camera;
    private EJGEngine engine;

    public CameraCalculator(Camera camera, EJGEngine e) {
        this.camera = camera;
        this.engine = e;
    }

    public GameLocation getGameLocationFromVector2D(Vector2D position) {
        float tileSize = this.engine.getWindow().getTileSize();
        float zoom = this.camera.getZoom();
        Vector2D cameraPos = this.camera.getPosition();
        Vector2D cameraOrigin = this.camera.getOrigin();
        float localX = position.getX() - cameraOrigin.getX();
        float localY = position.getY() - cameraOrigin.getY();
        float rotation = this.camera.getRotation();
        float radians = (float)Math.toRadians(-rotation);
        float rotatedX = (float)((double)localX * Math.cos(radians) - (double)localY * Math.sin(radians));
        float rotatedY = (float)((double)localX * Math.sin(radians) + (double)localY * Math.cos(radians));
        float worldX = (rotatedX + cameraPos.getX()) / (tileSize * zoom);
        float worldY = (rotatedY + cameraPos.getY()) / (tileSize * zoom);
        return new GameLocation(worldX, worldY);
    }
}

