/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib;

import org.colomoto.mddlib.MDDComparator;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.PathSearcher;

class HeavyComparator
implements MDDComparator {
    private final MDDManager ddm1;
    private final MDDManager ddm2;
    private final PathSearcher searcher;
    private final int[] pathMap;
    private final byte[] path2;

    public HeavyComparator(MDDManager ddm1, MDDManager ddm2) {
        int i;
        this.ddm1 = ddm1;
        this.ddm2 = ddm2;
        this.searcher = new PathSearcher(ddm1);
        this.pathMap = new int[ddm1.getAllVariables().length];
        for (i = 0; i < this.pathMap.length; ++i) {
            this.pathMap[i] = -1;
        }
        i = -1;
        for (MDDVariable v : ddm1.getAllVariables()) {
            int i2;
            ++i;
            MDDVariable v2 = ddm2.getVariableForKey(v.key);
            if (v2 == null || v2.nbval != v.nbval) continue;
            this.pathMap[i] = i2 = ddm2.getVariableIndex(v2);
        }
        this.path2 = new byte[ddm2.getAllVariables().length];
    }

    @Override
    public boolean similar(int n1, int n2) {
        int[] path = this.searcher.setNode(n1);
        for (int value : this.searcher) {
            byte[] p2 = this.fillPath(path);
            if (p2 == null) {
                return false;
            }
            byte v2 = this.ddm2.groupReach(n2, p2);
            if (v2 == value) continue;
            return false;
        }
        return true;
    }

    private byte[] fillPath(int[] p) {
        for (int i = 0; i < p.length; ++i) {
            int v = p[i];
            int i2 = this.pathMap[i];
            if (v < 0 && i2 < 0) continue;
            if (i2 < 0) {
                return null;
            }
            this.path2[i2] = (byte)v;
        }
        return this.path2;
    }
}

