/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib;

import java.util.ArrayList;
import java.util.List;
import org.colomoto.mddlib.CompatibleComparator;
import org.colomoto.mddlib.HeavyComparator;
import org.colomoto.mddlib.IdenticalComparator;
import org.colomoto.mddlib.MDDComparator;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;

public class MDDComparatorFactory {
    public static MDDComparator getComparator(MDDManager ddm1, MDDManager ddm2) {
        if (ddm1.isView(ddm2)) {
            System.out.println("Compare in the same store");
            return new IdenticalComparator();
        }
        List<MDDVariable[]> shared = MDDComparatorFactory.getSharedVars(ddm1, ddm2);
        if (MDDComparatorFactory.areCompatible(shared)) {
            return new CompatibleComparator(ddm1, ddm2);
        }
        return new HeavyComparator(ddm1, ddm2);
    }

    private static List<MDDVariable[]> getSharedVars(MDDManager ddm1, MDDManager ddm2) {
        ArrayList<MDDVariable[]> shared = new ArrayList<MDDVariable[]>();
        for (MDDVariable v1 : ddm1.getAllVariables()) {
            MDDVariable v2 = ddm2.getVariableForKey(v1.key);
            if (v2 == null) continue;
            int pos = 0;
            for (MDDVariable[] orders : shared) {
                if (orders[0].order > v1.order) break;
                ++pos;
            }
            shared.add(pos, new MDDVariable[]{v1, v2});
        }
        return shared;
    }

    private static boolean areCompatible(List<MDDVariable[]> shared) {
        int o1 = -1;
        int o2 = -1;
        for (MDDVariable[] orders : shared) {
            if (orders[0].nbval != orders[1].nbval) {
                return false;
            }
            if (orders[0].order <= o1 || orders[1].order <= o2) {
                return false;
            }
            o1 = orders[0].order;
            o2 = orders[1].order;
        }
        return true;
    }
}

