/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib;

import org.colomoto.mddlib.IndexMapper;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.PathSearcher;
import org.colomoto.mddlib.operators.MDDBaseOperators;

public class MDDMapper {
    private final MDDManager sourceDDM;
    private final MDDManager targetDDM;
    private final PathSearcher searcher;
    private final IndexMapper indexMapper;
    private final MDDVariable[] variables;

    public MDDMapper(MDDManager sourceDDM, MDDManager targetDDM, IndexMapper indexMapper) {
        this.sourceDDM = sourceDDM;
        this.targetDDM = targetDDM;
        this.searcher = new PathSearcher(sourceDDM, 1, Integer.MAX_VALUE);
        this.indexMapper = indexMapper;
        this.variables = targetDDM.getAllVariables();
    }

    public int mapMDD(int node) {
        int result = 0;
        int[] path = this.searcher.setNode(node);
        for (int value : this.searcher) {
            int curBranch = 1;
            for (int i = 0; i < path.length; ++i) {
                byte v = (byte)path[i];
                if (v < 0) continue;
                int curVar = this.variables[this.indexMapper.get(i)].getNodeForValue(v, value);
                int nextBranch = MDDBaseOperators.AND.combine(this.targetDDM, curBranch, curVar);
                this.targetDDM.free(curBranch);
                this.targetDDM.free(curVar);
                curBranch = nextBranch;
            }
            int next = MDDBaseOperators.OVER.combine(this.targetDDM, result, curBranch);
            this.targetDDM.free(curBranch);
            this.targetDDM.free(result);
            result = next;
        }
        return result;
    }
}

