/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib;

import org.colomoto.mddlib.internal.MDDStore;

public class MDDVariable {
    public final Object key;
    public final byte nbval;
    public final int order;
    private final MDDStore store;

    public MDDVariable(MDDStore store, int order, Object key, byte nbval) {
        this.store = store;
        this.order = order;
        this.key = key;
        this.nbval = nbval;
    }

    public int getNodeForValue(int v, int value) {
        if (v < 0 || v >= this.nbval) {
            return 1;
        }
        if (this.nbval == 2) {
            if (v == 0) {
                return this.getNode(value, 0);
            }
            return this.getNode(0, value);
        }
        int[] children = new int[this.nbval];
        children[v] = value;
        return this.getNode(children);
    }

    public int getNode(int f, int t) {
        if (this.nbval != 2) {
            throw new RuntimeException("MDD: not a Boolean variable (nbval=" + this.nbval + ")");
        }
        return this.store.getNode(this.order, f, t);
    }

    public int getNode(int[] children) {
        if (this.nbval != children.length) {
            throw new RuntimeException("MDD: nbval mismatch (" + this.nbval + " vs " + children.length + ")");
        }
        return this.store.getNode(this.order, children);
    }

    public int getNodeFree(int f, int t) {
        int ret = this.getNode(f, t);
        this.store.free(f);
        this.store.free(t);
        return ret;
    }

    public int getNodeFree(int[] children) {
        int ret = this.getNode(children);
        for (int n : children) {
            this.store.free(n);
        }
        return ret;
    }

    public int getSimpleNode(int vfalse, int vtrue, int start, int end) {
        int i;
        if (start > end || start < 0) {
            return -1;
        }
        if (end >= this.nbval) {
            end = this.nbval - 1;
        }
        if (this.nbval == 2) {
            if (start != end) {
                return vtrue;
            }
            if (start == 0) {
                return this.store.getNode(this.order, vtrue, vfalse);
            }
            return this.store.getNode(this.order, vfalse, vtrue);
        }
        int[] children = new int[this.nbval];
        for (i = 0; i < start; ++i) {
            children[i] = vfalse;
        }
        for (i = start; i <= end; ++i) {
            children[i] = vtrue;
        }
        for (i = end + 1; i < this.nbval; ++i) {
            children[i] = vfalse;
        }
        return this.store.getNode(this.order, children);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof MDDVariable) {
            MDDVariable ovar = (MDDVariable)other;
            return this.key.equals(ovar.key) && this.nbval == ovar.nbval;
        }
        return this.key.equals(other);
    }

    public boolean after(MDDVariable other) {
        if (other == null) {
            return false;
        }
        return other.order < this.order;
    }

    public static MDDVariable selectFirstVariable(MDDVariable v1, MDDVariable v2) {
        if (v1 == null || v1.after(v2)) {
            return v2;
        }
        return v1;
    }

    public String toString() {
        return this.key.toString();
    }
}

