/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib;

import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;

class PathBacktrack {
    final MDDManager ddmanager;
    final int[] indices;
    final int[] values;
    public int pos;

    public PathBacktrack(MDDManager ddmanager) {
        this.ddmanager = ddmanager;
        this.indices = new int[ddmanager.getAllVariables().length];
        this.values = new int[this.indices.length];
    }

    public void reset(int node) {
        this.pos = 0;
        this.indices[0] = node;
        this.values[0] = -1;
        for (int i = 1; i < this.indices.length; ++i) {
            this.indices[i] = -1;
            this.values[i] = -1;
        }
    }

    public void fillPath(int[] path) {
        for (int i = 0; i < path.length; ++i) {
            path[i] = -1;
        }
        for (int idx = 0; idx <= this.pos; ++idx) {
            MDDVariable var = this.ddmanager.getNodeVariable(this.indices[idx]);
            int i = this.ddmanager.getVariableIndex(var);
            path[i] = this.values[idx];
        }
    }

    public void fillPathAndMax(int[] path, int[] tmax) {
        for (int i = 0; i < path.length; ++i) {
            path[i] = -1;
            tmax[i] = -1;
        }
        for (int idx = 0; idx <= this.pos; ++idx) {
            int nextvalue;
            int mdd = this.indices[idx];
            int value = this.values[idx];
            int child = this.ddmanager.getChild(mdd, value);
            MDDVariable var = this.ddmanager.getNodeVariable(mdd);
            int max = value;
            int absolutemax = var.nbval - 1;
            while (max < absolutemax && this.ddmanager.getChild(mdd, nextvalue = max + 1) == child) {
                max = nextvalue;
            }
            if (max > value && max >= absolutemax) {
                max = -1;
            }
            int i = this.ddmanager.getVariableIndex(var);
            path[i] = this.values[idx];
            tmax[i] = max;
        }
    }

    public int findNextLeaf() {
        if (this.pos < 0) {
            throw new RuntimeException("findNext called after exploration is finished");
        }
        int node = this.indices[this.pos];
        if (this.ddmanager.isleaf(node)) {
            throw new RuntimeException("findNext went too far");
        }
        int curValue = this.values[this.pos] + 1;
        MDDVariable var = this.ddmanager.getNodeVariable(node);
        if (curValue < var.nbval) {
            int n = this.pos++;
            this.values[n] = this.values[n] + 1;
            int next = this.ddmanager.getChild(node, curValue);
            if (this.ddmanager.isleaf(next)) {
                return next;
            }
            this.indices[this.pos] = next;
            this.values[this.pos] = -1;
        } else {
            --this.pos;
            if (this.pos < 0) {
                return -1;
            }
        }
        return this.findNextLeaf();
    }

    public int findNextLeafMaxVersion() {
        if (this.pos < 0) {
            throw new RuntimeException("findNext called after exploration is finished");
        }
        int node = this.indices[this.pos];
        if (this.ddmanager.isleaf(node)) {
            throw new RuntimeException("findNext went too far");
        }
        int curValue = this.values[this.pos];
        MDDVariable var = this.ddmanager.getNodeVariable(node);
        if (curValue >= 0) {
            int curChild;
            int child = this.ddmanager.getChild(node, curValue);
            ++curValue;
            while (curValue < var.nbval && (curChild = this.ddmanager.getChild(node, curValue)) == child) {
                ++curValue;
            }
        } else {
            ++curValue;
        }
        if (curValue < var.nbval) {
            this.values[this.pos] = curValue;
            int next = this.ddmanager.getChild(node, curValue);
            if (this.ddmanager.isleaf(next)) {
                return next;
            }
            ++this.pos;
            this.indices[this.pos] = next;
            this.values[this.pos] = -1;
        } else {
            --this.pos;
            if (this.pos < 0) {
                return -1;
            }
        }
        return this.findNextLeafMaxVersion();
    }
}

