/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.PathBacktrack;

class PathFoundIterator
implements Iterator<Integer> {
    private final PathBacktrack backtrack;
    private final int[] path;
    private final int[] tmax;
    private final int minvalue;
    private final int maxvalue;
    private int leaf;

    public PathFoundIterator(MDDManager ddmanager, int node, int[] path, int min, int max) {
        this(ddmanager, node, path, null, min, max);
    }

    public PathFoundIterator(MDDManager ddmanager, int node, int[] path, int[] tmax, int min, int max) {
        this.path = path;
        this.minvalue = min;
        this.maxvalue = max;
        this.tmax = tmax;
        this.backtrack = new PathBacktrack(ddmanager);
        this.backtrack.reset(node);
        this.leaf = this.getNextLeaf(tmax != null);
    }

    @Override
    public boolean hasNext() {
        return this.leaf >= 0;
    }

    @Override
    public Integer next() {
        if (this.leaf < 0) {
            throw new NoSuchElementException();
        }
        int ret = this.leaf;
        if (this.tmax == null) {
            this.backtrack.fillPath(this.path);
            this.leaf = this.getNextLeaf(false);
        } else {
            this.backtrack.fillPathAndMax(this.path, this.tmax);
            this.leaf = this.getNextLeaf(true);
        }
        return ret;
    }

    @Override
    public void remove() {
    }

    public int getNextLeaf(boolean intervals) {
        while (this.leaf >= 0) {
            this.leaf = intervals ? this.backtrack.findNextLeafMaxVersion() : this.backtrack.findNextLeaf();
            if (this.leaf < this.minvalue || this.leaf > this.maxvalue) continue;
            return this.leaf;
        }
        return -1;
    }
}

