/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib;

import java.util.Iterator;
import org.colomoto.mddlib.EmptyIterator;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.PathFoundIterator;
import org.colomoto.mddlib.SingleLeafIterator;

public class PathSearcher
implements Iterable<Integer> {
    private final int minvalue;
    private final int maxvalue;
    private final MDDManager ddmanager;
    private final int[] path;
    private final int[] max;
    private int node;

    public PathSearcher(MDDManager ddmanager) {
        this(ddmanager, 0, Integer.MAX_VALUE);
    }

    public PathSearcher(MDDManager ddmanager, boolean detectIntervals) {
        this(ddmanager, 0, Integer.MAX_VALUE, detectIntervals);
    }

    public PathSearcher(MDDManager ddmanager, int value) {
        this(ddmanager, value, value);
    }

    public PathSearcher(MDDManager ddmanager, int value, boolean detectIntervals) {
        this(ddmanager, value, value, detectIntervals);
    }

    public PathSearcher(MDDManager ddmanager, int minvalue, int maxvalue) {
        this(ddmanager, minvalue, maxvalue, false);
    }

    public PathSearcher(MDDManager ddmanager, int minvalue, int maxvalue, boolean detectIntervals) {
        this.minvalue = minvalue;
        this.maxvalue = maxvalue;
        this.ddmanager = ddmanager;
        this.path = new int[ddmanager.getAllVariables().length];
        this.max = (int[])(detectIntervals ? new int[this.path.length] : null);
    }

    public int[] setNode(int node) {
        this.node = node;
        return this.getPath();
    }

    public int[] getPath() {
        return this.path;
    }

    public int[] getMax() {
        if (this.max == null) {
            throw new RuntimeException("This path searcher does not support intervals");
        }
        return this.max;
    }

    @Override
    public Iterator<Integer> iterator() {
        if (this.ddmanager.isleaf(this.node)) {
            if (this.node >= this.minvalue && this.node <= this.maxvalue) {
                int i;
                for (i = 0; i < this.path.length; ++i) {
                    this.path[i] = -1;
                }
                if (this.max != null) {
                    for (i = 0; i < this.max.length; ++i) {
                        this.max[i] = -1;
                    }
                }
                return new SingleLeafIterator(this.node);
            }
            return EmptyIterator.EMPTYITERATOR;
        }
        if (this.max == null) {
            return new PathFoundIterator(this.ddmanager, this.node, this.path, this.minvalue, this.maxvalue);
        }
        return new PathFoundIterator(this.ddmanager, this.node, this.path, this.max, this.minvalue, this.maxvalue);
    }

    public int countPaths() {
        int ret = 0;
        for (Integer i : this) {
            ++ret;
        }
        return ret;
    }
}

