/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib.internal;

import java.text.ParseException;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;

class DumpedVariable {
    private final MDDVariable var;
    private final int[] children;
    private int filled;

    public DumpedVariable(MDDVariable var) {
        this.var = var;
        this.children = new int[var.nbval];
        this.filled = 0;
    }

    public void stack(int child, int p) throws ParseException {
        if (this.filled >= this.var.nbval) {
            throw new ParseException("Too many children for variable " + this.var.order + ", trying to stack " + child + ". Line " + p, p);
        }
        this.children[this.filled++] = child;
    }

    public int close(MDDManager ddmanager, int p) throws ParseException {
        if (this.filled != this.children.length) {
            throw new ParseException("Bad number of children for variable " + this.var.order, p);
        }
        int node = this.var.getNode(this.children);
        for (int c : this.children) {
            ddmanager.free(c);
        }
        return node;
    }
}

