/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib.internal;

import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.NodeRelation;
import org.colomoto.mddlib.VariableEffect;
import org.colomoto.mddlib.internal.MDDStore;
import org.colomoto.mddlib.operators.MDDBaseOperators;

public class MDDManagerProxy
implements MDDManager {
    private final MDDStore store;
    private int[] store2custom;
    private int[] custom2store;
    private MDDVariable[] variables;

    public static MDDManager getProxy(MDDStore store, List<?> customOrder) {
        int i;
        MDDVariable[] rawVariables = store.getAllVariables();
        boolean sameOrder = rawVariables.length == customOrder.size();
        int[] custom2store = new int[customOrder.size()];
        for (i = 0; i < custom2store.length; ++i) {
            custom2store[i] = -1;
        }
        i = 0;
        for (Object v : customOrder) {
            MDDVariable var = store.getVariableForKey(v);
            if (var.order != i) {
                sameOrder = false;
            }
            custom2store[i] = var.order;
            ++i;
        }
        if (sameOrder) {
            return store;
        }
        int[] store2custom = new int[rawVariables.length];
        for (i = 0; i < store2custom.length; ++i) {
            store2custom[i] = -1;
        }
        i = 0;
        for (int k : custom2store) {
            if (k >= 0) {
                store2custom[k] = i;
            }
            ++i;
        }
        return new MDDManagerProxy(store, custom2store, store2custom);
    }

    private MDDManagerProxy(MDDStore store, int[] custom2store, int[] store2custom) {
        this.store = store;
        this.custom2store = custom2store;
        this.store2custom = store2custom;
        this.variables = new MDDVariable[custom2store.length];
        MDDVariable[] storeVars = store.getAllVariables();
        int i = 0;
        for (int j : custom2store) {
            this.variables[i] = storeVars[j];
            ++i;
        }
    }

    @Override
    public byte reach(int node, byte[] values) {
        return this.store.reach(node, values, this.store2custom);
    }

    @Override
    public byte groupReach(int node, byte[] values) {
        return this.store.groupReach(node, values, this.store2custom);
    }

    @Override
    public MDDVariable getVariableForKey(Object key) {
        MDDVariable var = this.store.getVariableForKey(key);
        int idx = this.store2custom[var.order];
        if (idx < 0) {
            return null;
        }
        return var;
    }

    @Override
    public int nodeFromState(byte[] state, int value) {
        return this.store.nodeFromState(state, value, this.store2custom);
    }

    @Override
    public int nodeFromStates(Collection<byte[]> states, int value) {
        int node = 0;
        for (byte[] state : states) {
            int newNode = this.nodeFromState(state, value);
            int nextNode = MDDBaseOperators.OR.combine(this, node, newNode);
            this.free(newNode);
            this.free(node);
            node = nextNode;
        }
        return node;
    }

    @Override
    public int getVariableIndex(MDDVariable var) {
        return this.store2custom[var.order];
    }

    @Override
    public MDDVariable[] getAllVariables() {
        return this.variables;
    }

    @Override
    public MDDVariable ensureVariable(Object key, byte nbval) {
        MDDVariable inStore = this.store.ensureVariable(key, nbval);
        if (inStore.order >= this.variables.length) {
            MDDVariable[] extended = new MDDVariable[this.variables.length + 1];
            System.arraycopy(this.variables, 0, extended, 0, this.variables.length);
            extended[this.variables.length] = inStore;
            this.variables = extended;
            this.custom2store = this.extendmapping(this.custom2store, this.variables.length);
            this.store2custom = this.extendmapping(this.store2custom, this.variables.length);
        }
        return inStore;
    }

    private int[] extendmapping(int[] mapping, int l) {
        if (l <= mapping.length) {
            return mapping;
        }
        int[] extended = new int[l];
        System.arraycopy(mapping, 0, extended, 0, mapping.length);
        for (int i = mapping.length; i < extended.length; ++i) {
            extended[i] = i;
        }
        return extended;
    }

    @Override
    public MDDManager getManager(List<?> order) {
        return this.store.getManager(order);
    }

    @Override
    public MDDVariable getNodeVariable(int n) {
        return this.store.getNodeVariable(n);
    }

    @Override
    public void free(int pos) {
        this.store.free(pos);
    }

    @Override
    public int use(int node) {
        return this.store.use(node);
    }

    @Override
    public boolean isleaf(int node) {
        return this.store.isleaf(node);
    }

    @Override
    public int getChild(int node, int value) {
        return this.store.getChild(node, value);
    }

    @Override
    public int[] getChildren(int node) {
        return this.store.getChildren(node);
    }

    @Override
    public int not(int node) {
        return this.store.not(node);
    }

    @Override
    public int mnot(int node, int v) {
        return this.store.mnot(node, v);
    }

    @Override
    public NodeRelation getRelation(int first, int other) {
        return this.store.getRelation(first, other);
    }

    @Override
    public int getNodeCount() {
        return this.store.getNodeCount();
    }

    @Override
    public int getLeafCount() {
        return this.store.getLeafCount();
    }

    @Override
    public int getSign(int node, MDDVariable pivot) {
        return this.store.getSign(node, pivot);
    }

    @Override
    public boolean[] collectDecisionVariables(int node) {
        boolean[] inStore = this.store.collectDecisionVariables(node);
        boolean[] ret = new boolean[this.variables.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = inStore[this.custom2store[i]];
        }
        return ret;
    }

    @Override
    public VariableEffect getVariableEffect(MDDVariable var, int node) {
        return this.store.getVariableEffect(var, node);
    }

    @Override
    public VariableEffect[] getMultivaluedVariableEffect(MDDVariable var, int node) {
        return this.store.getMultivaluedVariableEffect(var, node);
    }

    @Override
    public boolean isView(MDDManager ddm) {
        if (this.store == ddm) {
            return true;
        }
        if (ddm instanceof MDDManagerProxy) {
            return this.store == ((MDDManagerProxy)ddm).store;
        }
        return false;
    }

    @Override
    public String dumpMDD(int node) {
        return this.store.dumpMDD(node);
    }

    @Override
    public int parseDump(String s) throws ParseException {
        return this.store.parseDump(s);
    }
}

