/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib.internal;

import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.MDDVariableFactory;
import org.colomoto.mddlib.NodeRelation;
import org.colomoto.mddlib.VariableEffect;
import org.colomoto.mddlib.internal.DumpedVariable;
import org.colomoto.mddlib.internal.MDDManagerProxy;
import org.colomoto.mddlib.internal.MDDStore;
import org.colomoto.mddlib.operators.MDDBaseOperators;

public class MDDStoreImpl
implements MDDStore {
    private static final int DEFAULT_CAPACITY = 100;
    private static final int DEFAULT_HASHITEMS = 20;
    private static final int FILL_LIMIT = 80;
    private static final int INC_COUNT = 1;
    private static final int INC_VALUES = 2;
    private static final int[] NOTFLIP = new int[]{1, 0};
    private static final boolean CANFREE = true;
    private static final boolean CANFREEHASH = true;
    protected MDDVariable[] variables;
    private int blocsize;
    private int[] hashcodes;
    private int[] hashitems;
    private int[] blocs;
    private int freeBloc = -1;
    private int freeItem = -1;
    private int lastitem = 0;
    private int lastbloc = 0;
    private int nbnodes = 0;
    private final int nbleaves;

    public MDDStoreImpl(Collection<?> keys, int nbleaves) {
        this(100, keys, nbleaves);
    }

    private MDDStoreImpl(int capacity, Collection<?> keys, int nbleaves) {
        this.variables = keys instanceof MDDVariableFactory ? this.getVariables((MDDVariableFactory)keys) : this.getBooleanVariables(keys);
        this.nbleaves = nbleaves;
        this.blocsize = 2;
        for (MDDVariable var : this.variables) {
            if (var.nbval <= this.blocsize) continue;
            this.blocsize = var.nbval;
        }
        this.blocsize += 2;
        this.hashcodes = new int[capacity * 2];
        this.hashitems = new int[20];
        this.reset_hash();
        this.lastbloc = nbleaves;
        this.blocs = new int[nbleaves + capacity * this.blocsize];
        for (int i = 0; i < nbleaves; ++i) {
            this.blocs[i] = i;
        }
    }

    @Override
    public MDDManager getManager(List<?> order) {
        return MDDManagerProxy.getProxy(this, order);
    }

    private MDDVariable[] getBooleanVariables(Collection<?> keys) {
        MDDVariable[] variables = new MDDVariable[keys.size()];
        int i = 0;
        byte v = 2;
        for (Object key : keys) {
            variables[i] = new MDDVariable(this, i, key, v);
            ++i;
        }
        return variables;
    }

    private MDDVariable[] getVariables(MDDVariableFactory keys) {
        MDDVariable[] variables = new MDDVariable[keys.size()];
        int i = 0;
        for (Object key : keys) {
            byte v = keys.getNbValue(key);
            variables[i] = new MDDVariable(this, i, key, v);
            ++i;
        }
        return variables;
    }

    @Override
    public MDDVariable getNodeVariable(int n) {
        if (this.isleaf(n)) {
            return null;
        }
        int l = this.getLevel(n);
        if (l < 0) {
            throw new RuntimeException("Invalid level found for " + n + ": free/use bug?");
        }
        return this.variables[l];
    }

    @Override
    public int getVariableIndex(MDDVariable var) {
        return var.order;
    }

    @Override
    public MDDVariable getVariableForKey(Object key) {
        for (MDDVariable var : this.variables) {
            if (!key.equals(var.key)) continue;
            return var;
        }
        return null;
    }

    @Override
    public MDDVariable ensureVariable(Object key, byte nbval) {
        MDDVariable var = this.getVariableForKey(key);
        if (var == null) {
            var = new MDDVariable(this, this.variables.length, key, nbval);
            MDDVariable[] extended = new MDDVariable[this.variables.length + 1];
            System.arraycopy(this.variables, 0, extended, 0, this.variables.length);
            extended[this.variables.length] = var;
            this.variables = extended;
        } else if (var.nbval < nbval) {
            throw new RuntimeException("changing the number of values of a component is not supported");
        }
        return var;
    }

    @Override
    public MDDVariable[] getAllVariables() {
        return this.variables;
    }

    @Override
    public synchronized int getNode(int var, int lchild, int rchild) {
        int pos;
        boolean hashexists;
        if (lchild == rchild) {
            return this.use(lchild);
        }
        if (!this.isleaf(lchild) && this.blocs[lchild] <= var || !this.isleaf(rchild) && this.blocs[rchild] <= var) {
            System.err.println("Invalid request");
            return -1;
        }
        int hash = this.compute_bhash(var, lchild, rchild);
        boolean bl = hashexists = this.hashcodes[hash] != -1;
        if (hashexists) {
            pos = this.hashcodes[hash];
            if (this.is_equal(pos, var, lchild, rchild)) {
                return this.use(pos);
            }
            int item = this.hashcodes[hash + 1];
            while (item != -1) {
                pos = this.hashitems[item];
                if (this.is_equal(pos, var, lchild, rchild)) {
                    return this.use(pos);
                }
                item = this.hashitems[item + 1];
            }
        }
        pos = this.get_free_bloc();
        this.blocs[pos] = var;
        this.blocs[pos + 1] = 0;
        this.blocs[pos + 2] = lchild;
        this.blocs[pos + 2 + 1] = rchild;
        this.use(lchild);
        this.use(rchild);
        ++this.nbnodes;
        if (100 * this.nbnodes / this.hashcodes.length > 80) {
            this.extend_hash();
        } else {
            this.place_hash(pos, hash);
        }
        return this.use(pos);
    }

    private int getNodeFree(int var, int f, int t) {
        int ret = this.getNode(var, f, t);
        this.free(f);
        this.free(t);
        return ret;
    }

    private int getNodeFree(int var, int[] children) {
        int ret = this.getNode(var, children);
        for (int c : children) {
            this.free(c);
        }
        return ret;
    }

    @Override
    public int getNode(int var, int[] children) {
        int pos;
        boolean hashexists;
        int child = children[0];
        for (int c : children) {
            if (c != child) {
                child = -1;
                break;
            }
            if (this.isleaf(c) || this.blocs[c] > var) continue;
            System.err.println("Invalid node request!");
            return -1;
        }
        if (child > -1) {
            return this.use(child);
        }
        int hash = this.compute_mhash(var, children);
        boolean bl = hashexists = this.hashcodes[hash] != -1;
        if (hashexists) {
            pos = this.hashcodes[hash];
            if (this.is_equal(pos, var, children)) {
                return this.use(pos);
            }
            int item = this.hashcodes[hash + 1];
            while (item != -1) {
                pos = this.hashitems[item];
                if (this.is_equal(pos, var, children)) {
                    return this.use(pos);
                }
                item = this.hashitems[item + 1];
            }
        }
        pos = this.get_free_bloc();
        this.blocs[pos] = var;
        this.blocs[pos + 1] = 0;
        System.arraycopy(children, 0, this.blocs, pos + 2, children.length);
        for (int c : children) {
            this.use(c);
        }
        ++this.nbnodes;
        if (100 * this.nbnodes / this.hashcodes.length > 80) {
            this.extend_hash();
        } else {
            this.place_hash(pos, hash);
        }
        return this.use(pos);
    }

    @Override
    public synchronized int use(int node) {
        if (!this.isleaf(node)) {
            int n = node + 1;
            this.blocs[n] = this.blocs[n] + 1;
        }
        return node;
    }

    @Override
    public synchronized void free(int pos) {
        if (this.isleaf(pos)) {
            return;
        }
        if (this.blocs[pos + 1] > 1) {
            int n = pos + 1;
            this.blocs[n] = this.blocs[n] - 1;
            return;
        }
        if (this.blocs[pos] < 0) {
            System.err.println("re-free bloc: " + pos);
            return;
        }
        int var = this.blocs[pos];
        int nbval = this.variables[var].nbval;
        this.freeHash(pos, var, nbval);
        this.blocs[pos] = -1;
        if (this.lastbloc == pos + this.blocsize) {
            this.lastbloc = pos;
        } else {
            this.blocs[pos + 1] = this.freeBloc;
            this.freeBloc = pos;
        }
        for (int i = 0; i < nbval; ++i) {
            this.free(this.blocs[pos + 2 + i]);
            this.blocs[pos + 2 + i] = 0;
        }
        --this.nbnodes;
    }

    private void freeHash(int pos, int var, int nbval) {
        int hash;
        if (nbval == 2) {
            hash = this.compute_bhash(var, this.blocs[pos + 2], this.blocs[pos + 2 + 1]);
        } else {
            int[] children = new int[this.variables[var].nbval];
            System.arraycopy(this.blocs, pos + 2, children, 0, children.length);
            hash = this.compute_mhash(var, children);
        }
        int hpos = this.hashcodes[hash];
        int itemPos = this.hashcodes[hash + 1];
        if (hpos == pos) {
            if (itemPos == -1) {
                this.hashcodes[hash] = -1;
            } else {
                this.hashcodes[hash] = this.hashitems[itemPos];
                this.hashcodes[hash + 1] = this.hashitems[itemPos + 1];
                this.free_hashitem(itemPos);
            }
            return;
        }
        int prevItem = -1;
        while (itemPos != -1) {
            hpos = this.hashitems[itemPos];
            int nextItem = this.hashitems[itemPos + 1];
            if (hpos == pos) {
                if (prevItem == -1) {
                    this.hashcodes[hash + 1] = nextItem;
                } else {
                    this.hashitems[prevItem + 1] = nextItem;
                }
                this.free_hashitem(itemPos);
                return;
            }
            prevItem = itemPos;
            itemPos = nextItem;
        }
        System.err.println("item not found !!!!");
    }

    private void free_hashitem(int item) {
        if (item < 0) {
            throw new RuntimeException("Trying to free a negative hashitem");
        }
        if (item == this.lastitem - 2) {
            this.lastitem = item;
        } else {
            this.hashitems[item] = -1;
            this.hashitems[item + 1] = this.freeItem;
            this.freeItem = item;
        }
    }

    private void place_hash(int blocPos, int hash) {
        int pos;
        if (this.hashcodes[hash] == -1) {
            this.hashcodes[hash] = blocPos;
            this.hashcodes[hash + 1] = -1;
            return;
        }
        if (this.freeItem >= 0) {
            pos = this.freeItem;
            this.freeItem = this.hashitems[pos + 1];
        } else {
            pos = this.lastitem;
            this.lastitem += 2;
            if (this.lastitem > this.hashitems.length) {
                this.hashitems = this.extend_array(this.hashitems);
            }
        }
        this.hashitems[pos] = blocPos;
        this.hashitems[pos + 1] = this.hashcodes[hash + 1];
        if (this.hashcodes[hash + 1] == pos) {
            System.err.println("BIG BUG with hash link list!");
        }
        this.hashcodes[hash + 1] = pos;
    }

    private int leafFlip(int node, int[] newValues) {
        if (this.isleaf(node)) {
            if (node >= newValues.length) {
                return node;
            }
            return newValues[node];
        }
        int level = this.blocs[node];
        byte nbval = this.variables[level].nbval;
        if (nbval == 2) {
            int l = this.leafFlip(this.blocs[node + 2], newValues);
            int r = this.leafFlip(this.blocs[node + 2 + 1], newValues);
            return this.getNodeFree(level, l, r);
        }
        int[] children = new int[nbval];
        for (int i = 0; i < children.length; ++i) {
            children[i] = this.leafFlip(this.blocs[node + 2 + i], newValues);
        }
        return this.getNodeFree(level, children);
    }

    @Override
    public synchronized int not(int node) {
        return this.leafFlip(node, NOTFLIP);
    }

    @Override
    public synchronized int mnot(int node, int v) {
        int[] flipper = new int[v + 1];
        flipper[0] = v;
        for (int i = 1; i < v; ++i) {
            flipper[i] = i;
        }
        flipper[v] = 0;
        return this.leafFlip(node, flipper);
    }

    @Override
    public NodeRelation getRelation(int first, int other) {
        if (first == other) {
            if (this.isleaf(first)) {
                return NodeRelation.LL;
            }
            return NodeRelation.NN;
        }
        if (this.isleaf(first)) {
            if (this.isleaf(other)) {
                return NodeRelation.LL;
            }
            return NodeRelation.LN;
        }
        if (this.isleaf(other)) {
            return NodeRelation.NL;
        }
        int l1 = this.blocs[first];
        int l2 = this.blocs[other];
        if (l1 == l2) {
            return NodeRelation.NN;
        }
        if (l1 < l2) {
            return NodeRelation.NNn;
        }
        return NodeRelation.NNf;
    }

    private int PAIR(int a, int b) {
        return (a + b) * (a + b + 1) / 2 + a;
    }

    private int compute_bhash(int var, int lchild, int rchild) {
        int hash = this.PAIR(rchild, this.PAIR(lchild, var));
        return Math.abs(hash) % (this.hashcodes.length / 2) * 2;
    }

    private int compute_mhash(int var, int[] children) {
        int hash = var;
        for (int i = 0; i < children.length; ++i) {
            hash = this.PAIR(children[i], hash);
        }
        return Math.abs(hash) % (this.hashcodes.length / 2) * 2;
    }

    private boolean is_equal(int position, int var, int lchild, int rchild) {
        return this.blocs[position] == var && this.blocs[position + 2] == lchild && this.blocs[position + 2 + 1] == rchild;
    }

    private boolean is_equal(int position, int var, int[] children) {
        if (this.blocs[position] != var) {
            return false;
        }
        for (int i = 0; i < children.length; ++i) {
            if (this.blocs[position + 2 + i] == children[i]) continue;
            return false;
        }
        return true;
    }

    private int get_free_bloc() {
        int pos = this.freeBloc;
        if (pos >= 0) {
            this.freeBloc = this.blocs[pos + 1];
            return pos;
        }
        pos = this.lastbloc;
        this.lastbloc += this.blocsize;
        if (this.lastbloc > this.blocs.length) {
            this.blocs = this.extend_array(this.blocs);
        }
        return pos;
    }

    private int[] extend_array(int[] data) {
        int[] new_array = new int[data.length * 2];
        System.arraycopy(data, 0, new_array, 0, data.length);
        return new_array;
    }

    private void extend_hash() {
        this.hashcodes = new int[this.hashcodes.length * 2];
        this.reset_hash();
        for (int i = this.nbleaves; i < this.lastbloc; i += this.blocsize) {
            int hash;
            int idvar = this.blocs[i];
            if (idvar < 0) continue;
            byte nbval = this.variables[idvar].nbval;
            if (nbval == 2) {
                hash = this.compute_bhash(idvar, this.blocs[i + 2], this.blocs[i + 2 + 1]);
            } else {
                int[] children = new int[nbval];
                System.arraycopy(this.blocs, i + 2, children, 0, nbval);
                hash = this.compute_mhash(idvar, children);
            }
            this.place_hash(i, hash);
        }
    }

    private void reset_hash() {
        int i;
        for (i = 0; i < this.hashcodes.length; ++i) {
            this.hashcodes[i] = -1;
        }
        for (i = 0; i < this.hashitems.length; ++i) {
            this.hashitems[i] = -1;
        }
        this.lastitem = 0;
        this.freeItem = -1;
    }

    @Override
    public int getNodeCount() {
        return this.nbnodes;
    }

    @Override
    public int getLeafCount() {
        return this.nbleaves;
    }

    @Override
    public boolean isleaf(int id) {
        return id < this.nbleaves;
    }

    private int getLevel(int id) {
        if (this.isleaf(id)) {
            return -1;
        }
        return this.blocs[id];
    }

    @Override
    public int getChild(int id, int value) {
        if (this.isleaf(id)) {
            return -1;
        }
        if (value < 0) {
            return -5;
        }
        return this.blocs[id + 2 + value];
    }

    @Override
    public int[] getChildren(int node) {
        if (this.isleaf(node)) {
            return null;
        }
        byte nbchildren = this.getNodeVariable((int)node).nbval;
        int[] next = new int[nbchildren];
        System.arraycopy(this.blocs, node + 2, next, 0, nbchildren);
        return next;
    }

    @Override
    public byte reach(int node, byte[] values) {
        while (!this.isleaf(node)) {
            int level = this.getLevel(node);
            node = this.getChild(node, values[level]);
        }
        return (byte)node;
    }

    @Override
    public byte reach(int node, byte[] values, int[] orderMap) {
        if (orderMap == null) {
            return this.reach(node, values);
        }
        while (!this.isleaf(node)) {
            int level = this.getLevel(node);
            node = this.getChild(node, values[orderMap[level]]);
        }
        return (byte)node;
    }

    @Override
    public byte groupReach(int node, byte[] values) {
        if (this.isleaf(node)) {
            return (byte)node;
        }
        int level = this.getLevel(node);
        byte v = values[level];
        if (v < 0) {
            byte ret = this.groupReach(this.getChild(node, 0), values);
            if (ret < 0) {
                return -1;
            }
            int n = this.variables[level].nbval;
            for (int i = 1; i < n; ++i) {
                byte nret = this.groupReach(this.getChild(node, i), values);
                if (nret == ret) continue;
                return -1;
            }
            return ret;
        }
        return this.groupReach(this.getChild(node, v), values);
    }

    @Override
    public byte groupReach(int node, byte[] values, int[] orderMap) {
        if (orderMap == null) {
            return this.groupReach(node, values);
        }
        throw new RuntimeException("Proxied group reach not implemented yet");
    }

    @Override
    public int getSign(int node, MDDVariable pivot) {
        return this.getSign(node, pivot, 0);
    }

    private int getSign(int node, MDDVariable pivot, int curSign) {
        block4: {
            MDDVariable var;
            block3: {
                if (this.isleaf(node)) {
                    return curSign;
                }
                var = this.getNodeVariable(node);
                if (var.order >= pivot.order) break block3;
                for (int i = 0; i < var.nbval; ++i) {
                    curSign = this.getSign(this.getChild(node, i), pivot, curSign);
                }
                break block4;
            }
            if (var != pivot) break block4;
            for (int i = 1; i < var.nbval; ++i) {
                curSign = this.getSign_sub(this.getChild(node, i - 1), this.getChild(node, i), curSign);
            }
        }
        return curSign;
    }

    private int getSign_sub(int n1, int n2, int curSign) {
        if (n1 == n2) {
            return curSign;
        }
        switch (this.getRelation(n1, n2)) {
            case LL: {
                if (n1 > n2) {
                    switch (curSign) {
                        case 0: {
                            curSign = -1;
                            break;
                        }
                        case 1: {
                            curSign = 2;
                        }
                    }
                    break;
                }
                if (n1 >= n2) break;
                switch (curSign) {
                    case 0: {
                        curSign = 1;
                        break;
                    }
                    case -1: {
                        curSign = 2;
                    }
                }
                break;
            }
            case LN: 
            case NNf: {
                int nbval = this.getNodeVariable((int)n2).nbval;
                for (int i = 0; i < nbval; ++i) {
                    curSign = this.getSign_sub(n1, this.getChild(n2, i), curSign);
                }
                break;
            }
            case NL: 
            case NNn: {
                int nbval = this.getNodeVariable((int)n1).nbval;
                for (int i = 0; i < nbval; ++i) {
                    curSign = this.getSign_sub(this.getChild(n1, i), n2, curSign);
                }
                break;
            }
            case NN: {
                int nbval = this.getNodeVariable((int)n1).nbval;
                for (int i = 0; i < nbval; ++i) {
                    curSign = this.getSign_sub(this.getChild(n1, i), this.getChild(n2, i), curSign);
                }
                break;
            }
        }
        return curSign;
    }

    @Override
    public boolean[] collectDecisionVariables(int node) {
        boolean[] vars = new boolean[this.variables.length];
        this.collectDecisionVariables(vars, node);
        return vars;
    }

    private void collectDecisionVariables(boolean[] flags, int node) {
        MDDVariable var = this.getNodeVariable(node);
        if (var == null) {
            return;
        }
        flags[this.getLevel((int)node)] = true;
        for (int i = 0; i < var.nbval; ++i) {
            this.collectDecisionVariables(flags, this.getChild(node, i));
        }
    }

    @Override
    public VariableEffect getVariableEffect(MDDVariable var, int node) {
        MDDVariable curVar = this.getNodeVariable(node);
        if (curVar == null || curVar.after(var)) {
            return VariableEffect.NONE;
        }
        if (curVar.equals(var)) {
            VariableEffect effect = VariableEffect.NONE;
            int curChild = this.getChild(node, 0);
            for (int value = 1; value < var.nbval; ++value) {
                int nextChild = this.getChild(node, value);
                if (nextChild == curChild) continue;
                effect = effect.combine(this.lookupEffect(curChild, nextChild));
                curChild = nextChild;
            }
            return effect;
        }
        int curChild = this.getChild(node, 0);
        VariableEffect effect = this.getVariableEffect(var, curChild);
        for (int value = 1; value < curVar.nbval; ++value) {
            int nextChild = this.getChild(node, value);
            if (nextChild == curChild) continue;
            curChild = nextChild;
            if ((effect = effect.combine(this.getVariableEffect(var, nextChild))) != VariableEffect.DUAL) continue;
            return effect;
        }
        return effect;
    }

    @Override
    public VariableEffect[] getMultivaluedVariableEffect(MDDVariable var, int node) {
        if (var.nbval == 2) {
            return new VariableEffect[]{this.getVariableEffect(var, node)};
        }
        VariableEffect[] effects = new VariableEffect[var.nbval - 1];
        for (int i = 1; i < var.nbval; ++i) {
            effects[i - 1] = VariableEffect.NONE;
        }
        this.inspectVariableEffect(var, node, effects);
        return effects;
    }

    private void inspectVariableEffect(MDDVariable var, int node, VariableEffect[] effects) {
        MDDVariable curVar = this.getNodeVariable(node);
        if (curVar == null || curVar.after(var)) {
            return;
        }
        if (curVar.equals(var)) {
            int curChild = this.getChild(node, 0);
            for (int value = 1; value < var.nbval; ++value) {
                int nextChild = this.getChild(node, value);
                if (nextChild == curChild) continue;
                effects[value - 1] = effects[value - 1].combine(this.lookupEffect(curChild, nextChild));
                curChild = nextChild;
            }
            return;
        }
        int curChild = this.getChild(node, 0);
        this.inspectVariableEffect(var, curChild, effects);
        for (int value = 1; value < curVar.nbval; ++value) {
            int nextChild = this.getChild(node, value);
            if (nextChild == curChild) continue;
            curChild = nextChild;
            this.inspectVariableEffect(var, nextChild, effects);
        }
    }

    private VariableEffect lookupEffect(int low, int high) {
        NodeRelation rel = this.getRelation(low, high);
        switch (rel) {
            case LL: {
                if (low < high) {
                    return VariableEffect.POSITIVE;
                }
                if (low > high) {
                    return VariableEffect.NEGATIVE;
                }
                return VariableEffect.NONE;
            }
            case LN: 
            case NNf: {
                MDDVariable var = this.getNodeVariable(high);
                int curChild = this.getChild(high, 0);
                VariableEffect effect = this.lookupEffect(low, curChild);
                for (int value = 1; value < var.nbval; ++value) {
                    int nextChild = this.getChild(high, value);
                    if (nextChild == curChild) continue;
                    curChild = nextChild;
                    if ((effect = effect.combine(this.lookupEffect(low, nextChild))) != VariableEffect.DUAL) continue;
                    return effect;
                }
                return effect;
            }
            case NL: 
            case NNn: {
                MDDVariable var = this.getNodeVariable(low);
                int curChild = this.getChild(low, 0);
                VariableEffect effect = this.lookupEffect(curChild, high);
                for (int value = 1; value < var.nbval; ++value) {
                    int nextChild = this.getChild(low, value);
                    if (nextChild == curChild) continue;
                    curChild = nextChild;
                    if ((effect = effect.combine(this.lookupEffect(nextChild, high))) != VariableEffect.DUAL) continue;
                    return effect;
                }
                return effect;
            }
            case NN: {
                MDDVariable var = this.getNodeVariable(high);
                int curChild = this.getChild(high, 0);
                int curChildLow = this.getChild(low, 0);
                VariableEffect effect = this.lookupEffect(curChildLow, curChild);
                for (int value = 1; value < var.nbval; ++value) {
                    int nextChild = this.getChild(high, value);
                    int nextChildLow = this.getChild(low, value);
                    if (nextChild == curChild && nextChildLow == curChildLow) continue;
                    curChild = nextChild;
                    curChildLow = nextChildLow;
                    if ((effect = effect.combine(this.lookupEffect(nextChildLow, nextChild))) != VariableEffect.DUAL) continue;
                    return effect;
                }
                return effect;
            }
        }
        throw new RuntimeException("Invalid node relation");
    }

    public void printNode(int node) {
        this.print(node, "");
    }

    private void print(int node, String prefix) {
        if (this.isleaf(node)) {
            System.out.println(prefix + node);
            return;
        }
        MDDVariable var = this.variables[this.blocs[node]];
        System.out.println(prefix + var.key);
        prefix = prefix + "   ";
        for (int i = 0; i < var.nbval; ++i) {
            this.print(this.blocs[node + 2 + i], prefix);
        }
    }

    public void debug() {
        System.out.println("------------------------------------------------------------");
        System.out.println("Raw factory info: ");
        System.out.println("    " + this.nbleaves + " leaves -- " + this.blocsize + " cell per bloc");
        System.out.println("    " + this.nbnodes + " nodes");
        System.out.print("Hashes: ");
        this.prettyPrintArray(this.hashcodes, 0, 2, -1);
        System.out.print("HList:  ");
        this.prettyPrintArray(this.hashitems, 0, 2, this.lastitem);
        System.out.print("Data:   ");
        this.prettyPrintArray(this.blocs, this.nbleaves, this.blocsize, this.lastbloc);
        System.out.println("------------------------------------------------------------");
    }

    private void prettyPrintArray(int[] a, int skip, int bs, int last) {
        if (last == -1) {
            last = a.length;
        }
        for (int i = 0; i < last; ++i) {
            int b = i - skip;
            if (b >= 0 && b % bs == 0) {
                System.out.print("| ");
            }
            System.out.print(a[i] + " ");
        }
        System.out.println();
    }

    @Override
    public boolean isView(MDDManager ddm) {
        if (ddm == this) {
            return true;
        }
        if (ddm instanceof MDDManagerProxy) {
            return ddm.isView(this);
        }
        return false;
    }

    @Override
    public synchronized int nodeFromState(byte[] state, int value) {
        if (value < 1) {
            return value;
        }
        int node = value;
        for (int l = this.variables.length - 1; l > -1; --l) {
            byte v = state[l];
            node = this.getSingleChildNode(l, v, node);
        }
        return node;
    }

    @Override
    public synchronized int nodeFromStates(Collection<byte[]> states, int value) {
        int node = 0;
        for (byte[] state : states) {
            int newNode = this.nodeFromState(state, value);
            int nextNode = MDDBaseOperators.OR.combine(this, node, newNode);
            this.free(newNode);
            this.free(node);
            node = nextNode;
        }
        return node;
    }

    @Override
    public synchronized int nodeFromState(byte[] state, int value, int[] orderMap) {
        if (orderMap == null) {
            return this.nodeFromState(state, value);
        }
        if (value < 1) {
            return value;
        }
        int node = value;
        for (int l = this.variables.length - 1; l > -1; --l) {
            byte v = state[orderMap[l]];
            int nextNode = this.getSingleChildNode(l, value, node);
            this.free(node);
            node = nextNode;
        }
        return node;
    }

    private synchronized int getSingleChildNode(int level, int value, int child) {
        if (value < 0) {
            return child;
        }
        MDDVariable var = this.variables[level];
        if (var.nbval == 2) {
            if (value == 0) {
                return var.getNode(child, 0);
            }
            return var.getNode(0, child);
        }
        int[] children = new int[var.nbval];
        children[value] = child;
        return var.getNode(children);
    }

    @Override
    public String dumpMDD(int mdd) {
        StringBuffer sb = new StringBuffer();
        this.write(mdd, sb);
        return sb.toString();
    }

    private void write(int mdd, StringBuffer s) {
        MDDVariable var = this.getNodeVariable(mdd);
        if (var == null) {
            s.append(mdd);
            return;
        }
        s.append('(');
        s.append(var.order);
        s.append(',');
        for (int i = 0; i < var.nbval; ++i) {
            if (i > 0) {
                s.append(',');
            }
            this.write(this.getChild(mdd, i), s);
        }
        s.append(')');
    }

    @Override
    public int parseDump(String s) throws ParseException {
        int length = s.length();
        if (length == 1) {
            int n = Integer.parseInt(s);
            if (this.isleaf(n)) {
                return n;
            }
            throw new ParseException("Value > max leaf", 0);
        }
        Stack<DumpedVariable> stack = new Stack<DumpedVariable>();
        int node = -1;
        for (int i = 0; i < length; ++i) {
            int nPos;
            char c = s.charAt(i);
            if (c == '(') {
                nPos = this.findValueEnd(s, ++i);
                int level = Integer.parseInt(s.substring(i, nPos));
                stack.add(new DumpedVariable(this.variables[level]));
                i = nPos - 1;
                continue;
            }
            if (c == ')') {
                node = ((DumpedVariable)stack.pop()).close(this, i);
                if (stack.empty()) {
                    if (i < length - 1) {
                        throw new ParseException("Malformed MDD dump", i);
                    }
                    return node;
                }
                ((DumpedVariable)stack.peek()).stack(node, i);
                continue;
            }
            if (c == ',') continue;
            nPos = this.findValueEnd(s, i);
            node = Integer.parseInt(s.substring(i, nPos));
            if (!this.isleaf(node)) {
                throw new ParseException("Value > max leaf", 0);
            }
            i = nPos - 1;
            if (stack.empty()) {
                if (i < length - 1) {
                    throw new ParseException("Malformed MDD dump", i);
                }
                return node;
            }
            ((DumpedVariable)stack.peek()).stack(node, i);
        }
        throw new ParseException("Malformed MDD dump", s.length());
    }

    private int findValueEnd(String s, int i) {
        while (Character.isDigit(s.charAt(i++))) {
        }
        return i - 1;
    }
}

