/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib.logicalfunction;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.colomoto.mddlib.logicalfunction.FunctionNode;
import org.colomoto.mddlib.logicalfunction.OperandFactory;
import org.colomoto.mddlib.logicalfunction.OperatorCollection;

public class FunctionParser {
    final OperatorCollection operatorCollection;
    final String operatorsAndParenthesis;
    final List<String> operators;

    public FunctionParser() {
        this(OperatorCollection.DEFAULT_OPERATORS);
    }

    public FunctionParser(OperatorCollection operatorCollection) {
        this.operatorCollection = operatorCollection;
        this.operatorsAndParenthesis = operatorCollection.getRegex();
        this.operators = operatorCollection.getOperators();
    }

    public FunctionNode compile(OperandFactory opFactory, String s) {
        FunctionNode tbtn;
        int i;
        String[] split = s.split(this.operatorsAndParenthesis);
        ArrayList<String> operands = new ArrayList<String>();
        for (i = 0; i < split.length; ++i) {
            if (split[i].equals("")) continue;
            operands.add(split[i]);
        }
        if (!opFactory.verifOperandList(operands)) {
            return null;
        }
        i = 0;
        Stack<FunctionNode> operandStack = new Stack<FunctionNode>();
        Stack<String> operatorStack = new Stack<String>();
        while (i != s.length()) {
            String elem = this.readElement(this.operators, operands, s, i);
            if (elem == null) {
                return null;
            }
            if (operands.contains(elem)) {
                try {
                    operandStack.push(opFactory.createOperand(elem));
                }
                catch (Exception e) {
                    return null;
                }
            } else if (elem.equals("(")) {
                operatorStack.push(elem);
            } else if (elem.equals(")")) {
                while (!((String)operatorStack.peek()).equals("(")) {
                    tbtn = this.operatorCollection.createOperator((String)operatorStack.pop(), operandStack);
                    if (tbtn == null) continue;
                    operandStack.push(tbtn);
                }
                operatorStack.pop();
            } else if (this.operators.contains(elem)) {
                int k;
                int j = this.operatorCollection.getPriority(elem);
                while (!operatorStack.empty() && (k = this.operatorCollection.getPriority((String)operatorStack.peek())) >= j) {
                    tbtn = this.operatorCollection.createOperator((String)operatorStack.pop(), operandStack);
                    if (tbtn == null) continue;
                    operandStack.push(tbtn);
                }
                operatorStack.push(elem);
            }
            i = elem.length() + s.indexOf(elem, i);
        }
        while (!operatorStack.empty()) {
            tbtn = this.operatorCollection.createOperator((String)operatorStack.pop(), operandStack);
            if (tbtn != null) {
                operandStack.push(tbtn);
                continue;
            }
            return null;
        }
        FunctionNode root = (FunctionNode)operandStack.pop();
        if (!operandStack.isEmpty()) {
            return null;
        }
        return root;
    }

    private String readElement(List<String> operators, List<String> operands, String s, int i) {
        String s2 = s.substring(i).trim();
        String ret = "";
        for (String tmp : operands) {
            if (!s2.startsWith(tmp) || tmp.length() <= ret.length()) continue;
            ret = tmp;
        }
        if (ret.equals("")) {
            for (String tmp : operators) {
                if (!s2.startsWith(tmp)) continue;
                ret = tmp;
                break;
            }
        }
        if (ret.equals("")) {
            return null;
        }
        return ret;
    }
}

