/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib.logicalfunction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.colomoto.mddlib.logicalfunction.FunctionNode;
import org.colomoto.mddlib.logicalfunction.OperatorFactory;
import org.colomoto.mddlib.logicalfunction.operators.AndOperatorFactory;
import org.colomoto.mddlib.logicalfunction.operators.NotOperatorFactory;
import org.colomoto.mddlib.logicalfunction.operators.OrOperatorFactory;

public class OperatorCollection {
    public static final OperatorCollection DEFAULT_OPERATORS = new OperatorCollection();
    private List<String> operatorList = null;
    private String operatorsAndParenthesis = null;
    private final Map<String, OperatorFactory> m_factories = new HashMap<String, OperatorFactory>();

    public FunctionNode createOperator(String value, Stack<FunctionNode> stack) {
        OperatorFactory of = this.m_factories.get(value);
        if (of == null) {
            throw new RuntimeException("invalid operator: " + value);
        }
        return of.getNode(stack);
    }

    public int getPriority(String value) {
        OperatorFactory of = this.m_factories.get(value);
        if (of == null) {
            return -1;
        }
        return of.getPriority();
    }

    public List<String> getOperators() {
        if (this.operatorList == null) {
            this.operatorList = new ArrayList<String>();
            for (OperatorFactory of : this.m_factories.values()) {
                this.operatorList.add(of.getSymbol());
            }
            this.operatorList.add("(");
            this.operatorList.add(")");
        }
        return this.operatorList;
    }

    public String getRegex() {
        if (this.operatorsAndParenthesis == null) {
            StringBuffer sb = new StringBuffer();
            for (OperatorFactory of : this.m_factories.values()) {
                sb.append("\\" + of.getSymbol() + "|");
            }
            sb.append("\\(|\\)| ");
            this.operatorsAndParenthesis = sb.toString();
        }
        return this.operatorsAndParenthesis;
    }

    public void addFactory(OperatorFactory factory) {
        this.m_factories.put(factory.getSymbol(), factory);
        this.operatorsAndParenthesis = null;
        this.operatorList = null;
    }

    static {
        DEFAULT_OPERATORS.addFactory(AndOperatorFactory.FACTORY);
        DEFAULT_OPERATORS.addFactory(OrOperatorFactory.FACTORY);
        DEFAULT_OPERATORS.addFactory(NotOperatorFactory.FACTORY);
    }
}

