/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib.logicalfunction;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDManagerFactory;
import org.colomoto.mddlib.logicalfunction.AbstractOperand;
import org.colomoto.mddlib.logicalfunction.OperandFactory;
import org.colomoto.mddlib.logicalfunction.SimpleOperand;

public class SimpleOperandFactory<T>
implements OperandFactory {
    private final Map<String, SimpleOperand<T>> operandMap = new HashMap<String, SimpleOperand<T>>();
    private final List<T> operands;
    private MDDManager ddmanager = null;

    public SimpleOperandFactory(List<T> operands) {
        this.operands = operands;
        int i = 0;
        for (T obj : operands) {
            SimpleOperand<T> operand = new SimpleOperand<T>(obj, i);
            ++i;
            this.operandMap.put(operand.toString(), operand);
        }
    }

    @Override
    public boolean verifOperandList(List<String> list) {
        return true;
    }

    @Override
    public AbstractOperand createOperand(String name) {
        return this.operandMap.get(name);
    }

    @Override
    public AbstractOperand createOperand(String name, int threshold) {
        if (threshold < 1 || threshold > 100) {
            return null;
        }
        SimpleOperand<T> operand = this.operandMap.get(name);
        if (threshold == 1 || operand == null) {
            return operand;
        }
        String key = name + "@" + threshold;
        SimpleOperand<T> thop = this.operandMap.get(key);
        if (thop == null) {
            thop = new SimpleOperand(operand.object, operand.variable, threshold);
            this.operandMap.put(key, thop);
        }
        return thop;
    }

    @Override
    public MDDManager getMDDManager() {
        if (this.ddmanager == null) {
            this.ddmanager = MDDManagerFactory.getManager(this.operands, 2);
        }
        return this.ddmanager;
    }
}

