/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib.logicalfunction.operators;

import java.util.Stack;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDOperator;
import org.colomoto.mddlib.logicalfunction.FunctionNode;
import org.colomoto.mddlib.logicalfunction.operators.AbstractOperator;

public abstract class AbstractBinaryOperator
extends AbstractOperator {
    protected final FunctionNode leftArg;
    protected final FunctionNode rightArg;

    public AbstractBinaryOperator(FunctionNode leftArg, FunctionNode rightArg) {
        this.leftArg = leftArg;
        this.rightArg = rightArg;
        if (leftArg == null || rightArg == null) {
            throw new RuntimeException("Wrong args?");
        }
    }

    public AbstractBinaryOperator(Stack<FunctionNode> stack) {
        this.rightArg = stack.pop();
        this.leftArg = stack.pop();
        if (this.leftArg == null || this.rightArg == null) {
            throw new RuntimeException("Wrong args?");
        }
    }

    @Override
    public String toString(boolean par) {
        boolean leftPar = true;
        if (this.leftArg.isLeaf()) {
            leftPar = false;
        } else if (((AbstractOperator)this.leftArg).getSymbol().equals(this.getSymbol())) {
            leftPar = false;
        }
        boolean rightPar = true;
        if (this.rightArg.isLeaf()) {
            rightPar = false;
        } else if (((AbstractOperator)this.rightArg).getSymbol().equals(this.getSymbol())) {
            rightPar = false;
        }
        String s = this.leftArg.toString(leftPar) + " " + this.getSymbol() + " " + this.rightArg.toString(rightPar);
        if (par) {
            s = "(" + s + ")";
        }
        return s;
    }

    @Override
    public int getNbArgs() {
        return 2;
    }

    @Override
    public FunctionNode[] getArgs() {
        FunctionNode[] r = new FunctionNode[]{this.leftArg, this.rightArg};
        return r;
    }

    @Override
    public int getMDD(MDDManager ddmanager) {
        int l = this.leftArg.getMDD(ddmanager);
        int r = this.rightArg.getMDD(ddmanager);
        int ret = this.getMDDOperation().combine(ddmanager, l, r);
        ddmanager.free(l);
        ddmanager.free(r);
        return ret;
    }

    protected abstract MDDOperator getMDDOperation();
}

