/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib.operators;

import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.NodeRelation;
import org.colomoto.mddlib.operators.AbstractOperator;

public abstract class AbstractFlexibleOperator
extends AbstractOperator {
    private boolean locked = false;
    private final MergeAction[] t = new MergeAction[NodeRelation.values().length];

    private AbstractFlexibleOperator(boolean multipleMerge) {
        super(multipleMerge);
        for (int i = 0; i < this.t.length; ++i) {
            this.t[i] = MergeAction.RECURSIVE;
        }
    }

    public AbstractFlexibleOperator(MergeAction A_LL, boolean multipleMerge) {
        this(multipleMerge);
        this.setAction(NodeRelation.LL, A_LL);
    }

    public AbstractFlexibleOperator(MergeAction A_LL) {
        this(A_LL, false);
    }

    protected void setAction(NodeRelation rel, MergeAction action) {
        if (this.locked) {
            return;
        }
        this.t[rel.ordinal()] = action;
    }

    protected void lock() {
        this.locked = true;
    }

    @Override
    public int combine(MDDManager ddmanager, int first, int other) {
        NodeRelation status = ddmanager.getRelation(first, other);
        MergeAction action = this.t[status.ordinal()];
        if (action == MergeAction.ASKME) {
            action = this.ask(ddmanager, status, first, other);
        }
        switch (action) {
            case CUSTOM: {
                return this.custom(ddmanager, status, first, other);
            }
            case RECURSIVE: {
                return this.recurse(ddmanager, status, first, other);
            }
            case THIS: {
                return ddmanager.use(first);
            }
            case OTHER: {
                return ddmanager.use(other);
            }
            case MIN: {
                if (first > other) {
                    return ddmanager.use(other);
                }
                return ddmanager.use(first);
            }
            case MAX: {
                if (first > other) {
                    return ddmanager.use(first);
                }
                return ddmanager.use(other);
            }
        }
        return -1;
    }

    public MergeAction ask(MDDManager ddmanager, NodeRelation status, int first, int other) {
        return null;
    }

    public int custom(MDDManager ddmanager, NodeRelation status, int first, int other) {
        return -1;
    }

    protected static enum MergeAction {
        RECURSIVE,
        THIS,
        OTHER,
        MIN,
        MAX,
        ASKME,
        CUSTOM;

    }
}

