/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.mddlib.operators;

import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDOperator;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.NodeRelation;

public abstract class AbstractOperator
implements MDDOperator {
    private final boolean multipleMerge;

    public AbstractOperator() {
        this(false);
    }

    public AbstractOperator(boolean multipleMerge) {
        this.multipleMerge = multipleMerge;
    }

    public int recurse(MDDManager ddmanager, NodeRelation status, int first, int other) {
        switch (status) {
            case LN: 
            case NNf: {
                MDDVariable var = ddmanager.getNodeVariable(other);
                if (var.nbval == 2) {
                    int l = this.combine(ddmanager, first, ddmanager.getChild(other, 0));
                    int r = this.combine(ddmanager, first, ddmanager.getChild(other, 1));
                    return var.getNodeFree(l, r);
                }
                int[] children = new int[var.nbval];
                for (int i = 0; i < children.length; ++i) {
                    children[i] = this.combine(ddmanager, first, ddmanager.getChild(other, i));
                }
                return var.getNodeFree(children);
            }
            case NL: 
            case NNn: {
                MDDVariable var = ddmanager.getNodeVariable(first);
                if (var.nbval == 2) {
                    int l = this.combine(ddmanager, ddmanager.getChild(first, 0), other);
                    int r = this.combine(ddmanager, ddmanager.getChild(first, 1), other);
                    return var.getNodeFree(l, r);
                }
                int[] children = new int[var.nbval];
                for (int i = 0; i < children.length; ++i) {
                    children[i] = this.combine(ddmanager, ddmanager.getChild(first, i), other);
                }
                return var.getNodeFree(children);
            }
            case NN: {
                MDDVariable var = ddmanager.getNodeVariable(first);
                if (var.nbval == 2) {
                    int l = this.combine(ddmanager, ddmanager.getChild(first, 0), ddmanager.getChild(other, 0));
                    int r = this.combine(ddmanager, ddmanager.getChild(first, 1), ddmanager.getChild(other, 1));
                    return var.getNodeFree(l, r);
                }
                int[] children = new int[var.nbval];
                for (int i = 0; i < children.length; ++i) {
                    children[i] = this.combine(ddmanager, ddmanager.getChild(first, i), ddmanager.getChild(other, i));
                }
                return var.getNodeFree(children);
            }
        }
        return -1;
    }

    @Override
    public int combine(MDDManager ddmanager, int[] nodes) {
        switch (nodes.length) {
            case 0: {
                throw new RuntimeException("Need at least one node to merge");
            }
            case 1: {
                return ddmanager.use(nodes[0]);
            }
            case 2: {
                return this.combine(ddmanager, nodes[0], nodes[1]);
            }
        }
        int result = nodes[0];
        if (this.multipleMerge) {
            return this.combine(ddmanager, nodes, 0);
        }
        int oldresult = 0;
        for (int i = 1; i < nodes.length; ++i) {
            ddmanager.free(oldresult);
            oldresult = result = this.combine(ddmanager, result, nodes[i]);
        }
        return result;
    }

    protected int multiple_leaves(MDDManager ddmanager, int[] leaves) {
        if (leaves.length < 1) {
            throw new RuntimeException("Need at least one node to merge");
        }
        int result = leaves[0];
        int oldresult = 0;
        for (int i = 1; i < leaves.length; ++i) {
            ddmanager.free(oldresult);
            oldresult = result = this.combine(ddmanager, result, leaves[i]);
        }
        return result;
    }

    private int combine(MDDManager ddmanager, int[] nodes, int leafcount) {
        MDDVariable bestVar = null;
        for (int i = leafcount; i < nodes.length; ++i) {
            int id = nodes[i];
            if (ddmanager.isleaf(id)) {
                nodes[i] = nodes[leafcount];
                nodes[leafcount] = id;
                ++leafcount;
                continue;
            }
            MDDVariable var = ddmanager.getNodeVariable(id);
            bestVar = MDDVariable.selectFirstVariable(bestVar, var);
        }
        if (leafcount == nodes.length) {
            return this.multiple_leaves(ddmanager, nodes);
        }
        return this.recurse_multiple(ddmanager, nodes, leafcount, bestVar);
    }

    static final int[] prune_start(int[] nodes, int skip) {
        if (skip < 1) {
            return nodes;
        }
        int[] new_nodes = new int[nodes.length - skip];
        System.arraycopy(nodes, skip, new_nodes, 0, new_nodes.length);
        return new_nodes;
    }

    protected int recurse_multiple(MDDManager ddmanager, int[] nodes, int leafcount, MDDVariable bestVar) {
        if (bestVar.nbval == 2) {
            int i;
            int[] lnodes = new int[nodes.length];
            int[] rnodes = new int[nodes.length];
            for (i = 0; i < leafcount; ++i) {
                lnodes[i] = rnodes[i] = nodes[i];
            }
            for (i = leafcount; i < nodes.length; ++i) {
                int node = nodes[i];
                if (ddmanager.getNodeVariable(node) == bestVar) {
                    lnodes[i] = ddmanager.getChild(node, 0);
                    rnodes[i] = ddmanager.getChild(node, 1);
                    continue;
                }
                lnodes[i] = rnodes[i] = node;
            }
            int lchild = this.combine(ddmanager, lnodes, leafcount);
            int rchild = this.combine(ddmanager, rnodes, leafcount);
            return bestVar.getNodeFree(lchild, rchild);
        }
        int[] children = new int[bestVar.nbval];
        int[] nextnodes = new int[nodes.length];
        for (int v = 0; v < children.length; ++v) {
            System.arraycopy(nodes, 0, nextnodes, 0, leafcount);
            for (int i = leafcount; i < nodes.length; ++i) {
                int node = nodes[i];
                nextnodes[i] = ddmanager.getNodeVariable(node) == bestVar ? ddmanager.getChild(node, v) : nodes[i];
            }
            children[v] = this.combine(ddmanager, nextnodes, leafcount);
        }
        return bestVar.getNodeFree(children);
    }
}

