/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm;

import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.mddlib.MDDComparator;
import org.colomoto.mddlib.MDDComparatorFactory;
import org.colomoto.mddlib.MDDManager;

public class LogicalModelComparator {
    public static boolean compare(LogicalModel m1, LogicalModel m2) {
        List<NodeInfo> nodes1 = m1.getComponents();
        List<NodeInfo> nodes2 = m2.getComponents();
        int n = nodes1.size();
        if (n != nodes2.size()) {
            return false;
        }
        int i = 0;
        int[] nodeMap = new int[n];
        for (NodeInfo ni : nodes1) {
            int j = nodes2.indexOf(ni);
            if (j < 0) {
                return false;
            }
            nodeMap[i] = j;
            ++i;
        }
        MDDComparator comparator = MDDComparatorFactory.getComparator((MDDManager)m1.getMDDManager(), (MDDManager)m2.getMDDManager());
        int[] functions1 = m1.getLogicalFunctions();
        int[] functions2 = m2.getLogicalFunctions();
        for (i = 0; i < n; ++i) {
            if (comparator.similar(functions1[i], functions2[nodeMap[i]])) continue;
            return false;
        }
        return true;
    }
}

