/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm;

import org.colomoto.biolqm.NodeInfoHolder;
import org.colomoto.common.xml.XMLWriter;

public class NodeInfo {
    public static final byte UNDEFINED_MAX = -1;
    private String nodeID;
    private String name;
    private byte max;
    private boolean isInput = false;
    private int hashcode = -1;
    private NodeInfo[] booleanized_group = null;

    public NodeInfo(String uid) {
        this(uid, "", 1);
    }

    public NodeInfo(String uid, byte max) {
        this(uid, "", max);
    }

    public NodeInfo(String uid, String name, byte max) {
        this.setNodeID(uid);
        this.setName(name);
        this.max = max;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(String id) {
        if (!XMLWriter.isValidId(id)) {
            throw new RuntimeException("Invalid ID: " + id);
        }
        this.nodeID = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            this.name = "";
            return;
        }
        this.name = name.trim();
    }

    public byte getMax() {
        return this.max;
    }

    public void setMax(byte max) {
        this.max = max;
    }

    public boolean isInput() {
        return this.isInput;
    }

    public void setInput(boolean isInput) {
        this.isInput = isInput;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NodeInfo) {
            NodeInfo other = (NodeInfo)obj;
            return this.nodeID.equals(other.nodeID) && this.max == other.max && this.isInput == other.isInput;
        }
        if (obj instanceof NodeInfoHolder) {
            return this.equals(((NodeInfoHolder)obj).getNodeInfo());
        }
        return false;
    }

    public String getDisplayName() {
        if (this.name.length() > 0) {
            return this.name;
        }
        return this.nodeID;
    }

    public String toString() {
        return this.nodeID;
    }

    public NodeInfo[] getBooleanizedGroup() {
        return this.booleanized_group;
    }

    public void setBooleanizedGroup(NodeInfo[] booleanized_group) {
        this.booleanized_group = booleanized_group;
    }

    public NodeInfo clone() {
        NodeInfo clone = new NodeInfo(this.getNodeID(), this.max);
        clone.isInput = this.isInput;
        clone.hashcode = this.hashCode();
        return clone;
    }

    public int hashCode() {
        if (this.hashcode <= 0) {
            return super.hashCode();
        }
        return this.hashcode;
    }
}

