/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.helper;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class HelperTool {
    private final File binary;
    private static List<String> PATHS;
    private static String[] MY_PATHS;

    private static File lookup(String command) {
        return HelperTool.lookup(command, PATHS);
    }

    private static File lookup(String command, List<String> paths) {
        for (String folder : paths) {
            File f = new File(folder, command);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    public boolean isAvailable() {
        return this.binary != null && this.binary.canExecute();
    }

    public HelperTool(String command) {
        this.binary = HelperTool.lookup(command);
    }

    public ProcessBuilder getProcessBuilder(String ... args) {
        if (this.binary == null) {
            return null;
        }
        ArrayList<String> cmd = new ArrayList<String>(args.length + 1);
        cmd.add(this.binary.getAbsolutePath());
        for (String a : args) {
            cmd.add(a);
        }
        return new ProcessBuilder(cmd);
    }

    static {
        MY_PATHS = new String[]{"/opt/bin"};
        String[] paths = System.getenv("PATH").split(":");
        PATHS = new ArrayList<String>(paths.length + MY_PATHS.length);
        for (String s : MY_PATHS) {
            PATHS.add(s);
        }
        for (String s : paths) {
            PATHS.add(s);
        }
    }
}

