/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.helper.state;

import java.util.Iterator;

public class PatternStateIterator
implements Iterator<byte[]> {
    private final byte[] maxs;
    private byte[] next = null;
    private int[] jokers = null;
    private int nextJoker;

    public PatternStateIterator(byte[] pattern) {
        this.maxs = new byte[pattern.length];
        for (int i = 0; i < this.maxs.length; ++i) {
            this.maxs[i] = 1;
        }
        this.reset(pattern);
    }

    public PatternStateIterator(byte[] pattern, byte[] maxs) {
        this.maxs = maxs;
        this.reset(pattern);
    }

    public void reset(byte[] pattern) {
        this.next = (byte[])pattern.clone();
        int nb_jokers = 0;
        for (byte v : pattern) {
            if (v != -1) continue;
            ++nb_jokers;
        }
        this.jokers = new int[nb_jokers];
        int idx_joker = 0;
        int idx = 0;
        while (idx_joker < nb_jokers) {
            if (pattern[idx] == -1) {
                this.jokers[idx_joker++] = idx;
                this.next[idx] = 0;
            }
            ++idx;
        }
        this.nextJoker = 0;
    }

    public void reset(int[] pattern) {
        byte[] bpattern = new byte[pattern.length];
        for (int i = 0; i < pattern.length; ++i) {
            bpattern[i] = (byte)pattern[i];
        }
        this.reset(bpattern);
    }

    private void buildNext() {
        for (int j : this.jokers) {
            if (this.next[j] < this.maxs[j]) {
                int n = j;
                this.next[n] = (byte)(this.next[n] + 1);
                return;
            }
            this.next[j] = 0;
        }
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public byte[] next() {
        byte[] ret = (byte[])this.next.clone();
        this.buildNext();
        return ret;
    }
}

