/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io;

import java.lang.reflect.Method;
import org.colomoto.biolqm.io.LogicalModelFormat;
import org.colomoto.biolqm.service.BaseService;
import org.colomoto.biolqm.service.MultivaluedSupport;

public abstract class AbstractFormat
extends BaseService
implements LogicalModelFormat {
    private final boolean canExport;
    private final boolean canImport;
    private static final String NAME_IMPORT = "getLoader";
    private static final String NAME_EXPORT = "getExporter";

    protected AbstractFormat(String id, String name) {
        this(id, name, MultivaluedSupport.BOOLEAN_STRICT);
    }

    @Deprecated
    protected AbstractFormat(String id, String name, boolean supportsMultivalued) {
        this(id, name, MultivaluedSupport.MULTIVALUED);
    }

    protected AbstractFormat(String id, String name, MultivaluedSupport modelType) {
        this(id, (String[])null, name, modelType);
    }

    protected AbstractFormat(String id, String[] aliases, String name, MultivaluedSupport modelType) {
        super(id, aliases, name, "", modelType);
        boolean canImport = false;
        boolean canExport = false;
        Class<?> cl = this.getClass();
        for (Method m : cl.getMethods()) {
            if (m.getDeclaringClass() != cl) continue;
            if (NAME_IMPORT.equals(m.getName())) {
                canImport = true;
                continue;
            }
            if (!NAME_EXPORT.equals(m.getName())) continue;
            canExport = true;
        }
        this.canImport = canImport;
        this.canExport = canExport;
    }

    @Override
    public boolean canExport() {
        return this.canExport;
    }

    @Override
    public boolean canLoad() {
        return this.canImport;
    }

    @Override
    public String toString() {
        String cap = this.canImport ? (this.canExport ? "Import, Export" : "Import") : (this.canExport ? "Export" : "---");
        return this.getID() + "\t" + this.getName() + "\t" + cap;
    }
}

