/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.bnet;

import java.util.ArrayList;
import java.util.HashMap;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.io.BaseLoader;
import org.colomoto.biolqm.io.antlr.BNetLexer;
import org.colomoto.biolqm.io.antlr.BNetParser;
import org.colomoto.biolqm.io.antlr.ErrorListener;
import org.colomoto.biolqm.io.antlr.ExpressionStack;
import org.colomoto.biolqm.io.bnet.BNetParserListener;
import org.colomoto.mddlib.logicalfunction.FunctionNode;
import org.colomoto.mddlib.logicalfunction.OperandFactory;
import org.colomoto.mddlib.logicalfunction.SimpleOperandFactory;
import org.colomoto.mddlib.logicalfunction.operators.OrOperatorFactory;

public class BNetImport
extends BaseLoader {
    @Override
    protected LogicalModel performTask() throws Exception {
        ANTLRInputStream input = new ANTLRInputStream(this.streams.reader());
        ErrorListener errors = new ErrorListener();
        BNetParser parser = BNetImport.getParser((CharStream)input, errors);
        BNetParser.ModelContext mctx = parser.model();
        if (errors.hasErrors()) {
            System.out.println("Found some errors:");
            for (String s : errors.getErrors()) {
                System.out.println("  " + s);
            }
            return null;
        }
        HashMap<String, NodeInfo> id2var = new HashMap<String, NodeInfo>();
        ArrayList<NodeInfo> variables = new ArrayList<NodeInfo>();
        for (BNetParser.AssignContext actx : mctx.assign()) {
            String id = actx.var().ID().getText();
            if (id2var.containsKey(id)) continue;
            NodeInfo ni = new NodeInfo(id);
            id2var.put(id, ni);
            variables.add(ni);
        }
        SimpleOperandFactory operandFactory = new SimpleOperandFactory(variables);
        BNetParserListener listener = new BNetParserListener((OperandFactory)operandFactory);
        HashMap<NodeInfo, FunctionNode> var2function = new HashMap<NodeInfo, FunctionNode>();
        for (BNetParser.AssignContext actx : mctx.assign()) {
            String id = actx.var().ID().getText();
            NodeInfo ni = (NodeInfo)id2var.get(id);
            FunctionNode node = listener.loadExpr((ParseTree)actx.expr());
            FunctionNode curNode = (FunctionNode)var2function.get(ni);
            if (curNode != null) {
                node = OrOperatorFactory.FACTORY.getNode(curNode, node);
            }
            var2function.put(ni, node);
        }
        return ExpressionStack.constructModel((OperandFactory)operandFactory, variables, var2function);
    }

    private static BNetParser getParser(CharStream input, ErrorListener errors) {
        BNetLexer lexer = new BNetLexer(input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        BNetParser parser = new BNetParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errors);
        return parser;
    }
}

