/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.booleannet;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.io.BaseExporter;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.PathSearcher;

public class BooleanNetExport
extends BaseExporter {
    public BooleanNetExport(LogicalModel model) {
        super(model);
    }

    @Override
    public void export() throws IOException {
        MDDManager ddmanager = this.model.getMDDManager();
        MDDVariable[] variables = ddmanager.getAllVariables();
        PathSearcher searcher = new PathSearcher(ddmanager);
        OutputStreamWriter writer = this.streams.writer();
        writer.write("#BOOLEAN RULES\n");
        int[] functions = this.model.getLogicalFunctions();
        for (int idx = 0; idx < functions.length; ++idx) {
            MDDVariable var = variables[idx];
            writer.write(var + " *= ");
            int function = functions[idx];
            if (ddmanager.isleaf(function)) {
                writer.write(function + "\n");
                continue;
            }
            int[] path = searcher.setNode(function);
            boolean first = true;
            boolean multiple = false;
            StringBuffer funcBuffer = new StringBuffer();
            Iterator iterator = searcher.iterator();
            while (iterator.hasNext()) {
                int leaf = (Integer)iterator.next();
                if (leaf == 0) continue;
                if (!first) {
                    funcBuffer.append(") or (");
                    multiple = true;
                } else {
                    first = false;
                }
                boolean andFirst = true;
                for (int i = 0; i < path.length; ++i) {
                    int cst = path[i];
                    if (cst < 0) continue;
                    if (!andFirst) {
                        funcBuffer.append(" and ");
                    }
                    if (cst == 0) {
                        funcBuffer.append("not " + variables[i].key);
                    } else {
                        funcBuffer.append(variables[i].key.toString());
                    }
                    andFirst = false;
                }
            }
            if (multiple) {
                writer.write("(");
                writer.write(funcBuffer.toString());
                writer.write(")");
            } else {
                writer.write(funcBuffer.toString());
            }
            writer.write("\n");
        }
        ((Writer)writer).close();
    }
}

