/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.cnet;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.helper.implicants.RestrictedPathSearcher;
import org.colomoto.biolqm.io.BaseExporter;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.PathSearcher;

public class CNetExport
extends BaseExporter {
    public CNetExport(LogicalModel model) {
        super(model);
    }

    @Override
    public void export() throws IOException {
        MDDManager ddmanager = this.model.getMDDManager();
        MDDVariable[] variables = ddmanager.getAllVariables();
        PathSearcher searcher = new PathSearcher(ddmanager);
        OutputStreamWriter writer = this.streams.writer();
        writer.write("# model in CNET format, used by the tool BNS of E. Dubrova\n");
        writer.write("# see https://people.kth.se/~dubrova/bns.html\n");
        writer.write("\n");
        int[] functions = this.model.getLogicalFunctions();
        List<NodeInfo> components = this.model.getComponents();
        writer.write(".v " + components.size() + "\n");
        writer.write("# component order:\n");
        writer.write("# " + components + "\n");
        writer.write("\n");
        RestrictedPathSearcher implicants = new RestrictedPathSearcher(ddmanager);
        for (int i = 0; i < components.size(); ++i) {
            writer.write("# " + components.get(i).toString() + "\n");
            byte[] implicant = implicants.setNode(functions[i]);
            int[] regulators = implicants.getRegulatorList();
            String indices = "";
            for (int j = 0; j < regulators.length; ++j) {
                indices = indices + " " + (regulators[j] + 1);
            }
            writer.write(".n " + (i + 1) + " " + regulators.length + indices + "\n");
            for (int v : implicants) {
                String row = "";
                for (int k = 0; k < implicant.length; ++k) {
                    row = implicant[k] == -1 ? row + "-" : row + implicant[k];
                }
                if (row.length() > 0) {
                    row = row + " ";
                }
                writer.write(row + v + "\n");
            }
            writer.write("\n");
        }
        ((Writer)writer).close();
    }
}

