/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.gna;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.io.BaseExporter;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.PathSearcher;

public class GNAExport
extends BaseExporter {
    public GNAExport(LogicalModel model) {
        super(model);
    }

    @Override
    public void export() throws IOException {
        OutputStreamWriter writer = this.streams.writer();
        MDDManager ddmanager = this.model.getMDDManager();
        PathSearcher searcher = new PathSearcher(ddmanager);
        List<NodeInfo> nodeOrder = this.model.getComponents();
        int[] functions = this.model.getLogicalFunctions();
        MDDVariable[] variables = ddmanager.getAllVariables();
        for (int p = 0; p < functions.length; ++p) {
            int i;
            MDDVariable var = variables[p];
            int mdd = functions[p];
            String id = var.toString();
            boolean input = nodeOrder.get(p).isInput();
            writer.write((input ? "input" : "state") + "-variable: " + id + "\n  zero-parameter: zero_" + id + "\n  box-parameter: max_" + id + "\n  threshold-parameters: ");
            int thresholdLevels = var.nbval - 1;
            for (i = 1; i <= thresholdLevels; ++i) {
                writer.write("t" + i + "_" + id);
                if (i >= thresholdLevels) continue;
                writer.write(", ");
            }
            writer.write("\n");
            if (!input) {
                writer.write("  synthesis-parameters: ");
                if (mdd == 0) {
                    writer.write("k_" + id + ", ");
                }
                for (i = 1; i <= thresholdLevels; ++i) {
                    writer.write("k" + i + "_" + id);
                    if (i >= thresholdLevels) continue;
                    writer.write(", ");
                }
                writer.write("\n  degradation-parameters: g_" + id + "\n");
                writer.write("  state-equation:\n    d/dt " + id + " = ");
                if (mdd == 0) {
                    writer.write("k_" + id);
                } else {
                    GNAExport.browse(searcher, mdd, variables, id, writer);
                }
                writer.write("\n        - g_" + id + " * " + id + "\n");
            }
            writer.write("  parameter-inequalities:\n    zero_");
            if (!input && mdd == 0) {
                writer.write(id + " < k_" + id + " / g_" + id + " < ");
            } else {
                writer.write(id + " < ");
            }
            for (i = 1; i <= thresholdLevels; ++i) {
                writer.write("t" + i + "_" + id + " < ");
                if (input) continue;
                String last = "k" + i + "_" + id;
                for (int j = i; j > 0; --j) {
                    if (j == i) {
                        writer.write(last + " / g_" + id + " < ");
                        continue;
                    }
                    last = "k" + j + "_" + id + " + " + last;
                    writer.write("( " + last + " ) / g_" + id + " < ");
                }
            }
            writer.write("max_" + id + "\n");
        }
        ((Writer)writer).close();
    }

    private static void browse(PathSearcher searcher, int mdd, MDDVariable[] variables, String nodeID, Writer out) throws IOException {
        int[] path = searcher.setNode(mdd);
        HashMap mapEq = new HashMap();
        Iterator iterator = searcher.iterator();
        while (iterator.hasNext()) {
            int leaf = (Integer)iterator.next();
            if (leaf == 0) continue;
            String expr = "k" + leaf + "_" + nodeID;
            for (int i = 0; i < path.length; ++i) {
                int value = path[i];
                if (value == -1) continue;
                int end = value + 1;
                String nodeName = variables[i].toString();
                if (value > 0) {
                    expr = expr + " * s+(" + nodeName + ",t" + value + "_" + nodeName + ")";
                }
                if (end >= variables[i].nbval) continue;
                expr = expr + " * s-(" + nodeName + ",t" + end + "_" + nodeName + ")";
            }
            if (!mapEq.containsKey(leaf)) {
                mapEq.put(leaf, new HashSet());
            }
            ((Set)mapEq.get(leaf)).add(expr);
        }
        boolean first = true;
        Iterator iterator2 = mapEq.keySet().iterator();
        while (iterator2.hasNext()) {
            int leaf = (Integer)iterator2.next();
            for (String expr : (Set)mapEq.get(leaf)) {
                if (first) {
                    first = false;
                } else {
                    out.write("\n        + ");
                }
                out.write(expr);
            }
        }
    }
}

