/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.implicanttables;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.helper.implicants.RestrictedPathSearcher;
import org.colomoto.biolqm.helper.state.PatternStateIterator;
import org.colomoto.biolqm.io.BaseExporter;
import org.colomoto.mddlib.MDDManager;

public class ImplicantTableExport
extends BaseExporter {
    private boolean expand = true;

    public ImplicantTableExport(LogicalModel model) {
        super(model);
    }

    public void expand(boolean expand) {
        this.expand = expand;
    }

    @Override
    public void export() throws IOException {
        MDDManager ddmanager = this.model.getMDDManager();
        int[] functions = this.model.getLogicalFunctions();
        List<NodeInfo> components = this.model.getComponents();
        OutputStreamWriter writer = this.streams.writer();
        writer.write("# Logical model defined as a collection of implicant tables\n");
        writer.write("# " + components + "\n\n");
        RestrictedPathSearcher implicants = new RestrictedPathSearcher(ddmanager);
        for (int i = 0; i < components.size(); ++i) {
            NodeInfo ni = components.get(i);
            byte[] implicant = implicants.setNode(functions[i]);
            int[] regulators = implicants.getRegulatorList();
            byte[] maxs = new byte[regulators.length];
            for (int j = 0; j < regulators.length; ++j) {
                maxs[j] = components.get(regulators[j]).getMax();
                writer.write(components.get(regulators[j]).getNodeID());
                writer.write(" ");
            }
            writer.write(": ");
            writer.write(ni.getNodeID());
            if (ni.getMax() > 1) {
                writer.write("[" + ni.getMax() + "]");
            }
            writer.write("\n");
            PatternStateIterator expander = null;
            if (this.expand) {
                expander = new PatternStateIterator(maxs, maxs);
            }
            for (int v : implicants) {
                if (v == 0) continue;
                if (expander == null) {
                    this.writeState(writer, implicant, v);
                    continue;
                }
                expander.reset(implicant);
                while (expander.hasNext()) {
                    this.writeState(writer, expander.next(), v);
                }
            }
            writer.write("\n");
        }
        ((Writer)writer).close();
    }

    private void writeState(Writer writer, byte[] state, int target) throws IOException {
        char[] row = new char[state.length + 3];
        int k = 0;
        for (byte value : state) {
            row[k++] = value < 0 ? 45 : (char)(48 + value);
        }
        row[k++] = 58;
        row[k++] = (char)(48 + target);
        row[k++] = 10;
        writer.write(row);
    }
}

